<?php

// Extract settings with fallbacks
$btnText           = $settings['tj_btn_text'] ?? '';
$btnLinkType       = $settings['tj_btn_link_type'] ?? '';
$btnLink           = $settings['tj_btn_link'] ?? [];
$btnPageLink       = $settings['tj_btn_page_link'] ?? '';
$btnIcon           = $settings['tj_btn_icon'] ?? '';
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Initialize button class
$btnClass = 'tj-primary-btn tj-el-btn';

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $btnClass .= ' wow ' . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_btn_attr', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
  }
}

if ($btnLinkType === '2' && !empty($btnPageLink)) {
  $this->add_render_attribute('tj_btn_attr', 'href', esc_url(get_permalink($btnPageLink)));
  $this->add_render_attribute('tj_btn_attr', 'target', '_self');
  $this->add_render_attribute('tj_btn_attr', 'rel', 'nofollow');
} elseif (!empty($btnLink['url'])) {
  $this->add_link_attributes('tj_btn_attr', $btnLink);
}

$this->add_render_attribute('tj_btn_attr', 'class', esc_attr($btnClass));

?>

<?php if (!empty($btnText)) : ?>
  <div class="tj-btn-wrapper">
    <a <?php echo $this->get_render_attribute_string('tj_btn_attr'); ?>>
      <span class="btn-text"><span><?php echo esc_html($btnText); ?></span></span>
      <?php if (!empty($btnIcon['value'])) : ?>
        <span class="btn-icon">
          <?php tj_render_icon($settings, 'tj_btn_icon', 'btn_icon'); ?>
        </span>
      <?php endif; ?>
    </a>
  </div>
<?php endif; ?>