<?php
$tj_career_icon   = $settings['tj_career_icon'] ?? '';
$tj_career_meta   = $settings['tj_career_meta'] ?? '';
$tj_career_title   = $settings['tj_career_title'] ?? '';
$tj_career_location   = $settings['tj_career_location'] ?? '';
$careerLink =  $settings['tj_career_link'] ?? '';

$link = $careerLink['url'] ?? '';
$target = !empty($careerLink['is_external']) ? '_blank' : '';
$rel = !empty($careerLink['nofollow']) ? 'nofollow' : '';

$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

if (!empty($tjAnimation)) {
  $itemClass = "tj-careers-top wow $tjAnimationName";
  $this->add_render_attribute('tj_career_arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
} else {
  $itemClass = "tj-careers-top";
}
$this->add_render_attribute('tj_career_arg', 'class', $itemClass);
?>


<div <?php echo $this->get_render_attribute_string('tj_career_arg'); ?>>
  <?php if (!empty($tj_career_icon['value'])): ?>
    <div class="tj-careers-top-icon">
      <?php tj_render_icon($settings, 'tj_icon', 'tj_career_icon'); ?>
    </div>
  <?php endif; ?>
  <div class="tj-careers-top-content">
    <?php if (!empty($tj_career_meta)): ?>
      <div class="tj-careers-tag">
        <?php echo tj_kses($tj_career_meta); ?>
      </div>
    <?php endif; ?>
    <?php if (!empty($tj_career_title)): ?>
      <h3 class="tj-careers-top-title text-anim">
        <?php if (!empty($link)) :
          $href = 'href="' . esc_url($link) . '"';
          $target = !empty($target) ? 'target="' . esc_attr($target) . '"' : '';
          $rel = !empty($rel) ? 'rel="' . esc_attr($rel) . '"' : '';
        ?>
          <a <?php echo $href; ?> <?php echo $target; ?> <?php echo $rel; ?>>
            <?php echo esc_html($tj_career_title); ?>
          </a>
        <?php else: ?>
          <?php echo esc_html($tj_career_title); ?>
        <?php endif; ?>
      </h3>
    <?php endif; ?>
    <?php if (!empty($tj_career_location)): ?>
      <span class="location"><?php echo tj_kses($tj_career_location); ?></span>
    <?php endif; ?>
  </div>
</div>