<?php
$tjCounterCount   = $settings['tj_ff_number'] ?? '';
$tjCounterPrefix  = $settings['tj_ff_prefix'] ?? '';
$tjCounterSuffix  = $settings['tj_ff_suffix'] ?? '';
$tjCounterTitle   = $settings['tj_ff_title'] ?? '';
$tjCounterIcon    = $settings['tj_ff_icon'] ?? [];
$image = $settings['tj_image']['url'] ?? '';

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$counterClass = "countup-item style-2 style-3 tj-el-counter";
if (!empty($tjAnimation)) {
  $counterClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay . 's');
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<div <?php echo $this->get_render_attribute_string('tj-counter-arg'); ?> <?php if (!empty($image)) { ?> data-bg-image="<?php echo esc_url($image); ?>" <?php } ?>>

  <?php if (!empty($tjCounterIcon['value'])) : ?>
    <span class="count-icon tj-el-icon">
      <?php \Elementor\Icons_Manager::render_icon($tjCounterIcon, ['aria-hidden' => 'true']); ?>
    </span>
  <?php endif; ?>

  <div class="count-inner">
    <?php if (!empty($tjCounterTitle)) : ?>
      <span class="count-text tj-el-title"><?php echo tj_kses($tjCounterTitle); ?></span>
    <?php endif; ?>

    <?php if (is_numeric($tjCounterCount)) : ?>
      <div class="inline-content tj-el-number">
        <?php echo tj_kses($tjCounterPrefix); ?><span class="counter"><?php echo esc_html($tjCounterCount); ?></span><span class="count-plus"><?php echo tj_kses($tjCounterSuffix); ?></span>
      </div>
    <?php endif; ?>
  </div>
</div>