<?php
$tjCounterCount   = $settings['tj_ff_number'] ?? '';
$tjCounterPrefix  = $settings['tj_ff_prefix'] ?? '';
$tjCounterSuffix  = $settings['tj_ff_suffix'] ?? '';
$tjCounterTitle   = $settings['tj_ff_title'] ?? '';
$tjCounterDesc   = $settings['tj_ff_desc'] ?? '';
$tjCounterIcon    = $settings['tj_ff_icon'] ?? [];
$tjCounterSteps   = $settings['tj_ff_steps'] ?? '';

// animation
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$counterClass = "countup-item style-2 tj-el-counter";
if (!empty($tjAnimation)) {
  $counterClass .= " wow $tjAnimationName";
  $this->add_render_attribute('tj-counter-arg', 'data-wow-delay', $tjAnimationDelay . 's');
}
$this->add_render_attribute('tj-counter-arg', 'class', $counterClass);
?>

<div class="h8-about-counter">
  <div <?php $this->print_render_attribute_string('tj-counter-arg'); ?>>
    <div class="count-inner">
      <?php if (is_numeric($tjCounterCount)) : ?>
        <div class="inline-content tj-el-number">
          <?php echo tj_kses($tjCounterPrefix); ?>
          <span class="counter countup-number"><?php echo esc_html($tjCounterCount); ?></span>
          <?php echo tj_kses($tjCounterSuffix); ?>
        </div>
      <?php endif; ?>
      <?php if (!empty($tjCounterTitle)) : ?>
        <span class="count-text tj-el-title"><?php echo tj_kses($tjCounterTitle); ?></span>
      <?php endif; ?>
    </div>
  </div>
</div>