<?php

$lists          = $settings['tj_menu_list'] ?? [];
$tj_menu_title  = $settings['tj_menu_title'] ?? '';
$tjAnimation    = $settings['tj_animation'] ?? '';
$tjAnimationName = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

$listClass = 'footer-widget widget-nav-menu';
if (!empty($tjAnimation)) {
  $listClass .= ' wow ' . esc_attr($tjAnimationName);
  $this->add_render_attribute('tj_list_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}
$this->add_render_attribute('tj_list_attr', 'class', $listClass);
?>

<div <?php echo $this->get_render_attribute_string('tj_list_attr'); ?>>
  <?php if (!empty($tj_menu_title)) : ?>
    <h5 class="title"><?php echo esc_html($tj_menu_title); ?></h5>
  <?php endif; ?>

  <?php if (!empty($lists)) : ?>
    <div class="tj-footer-menu">
      <ul>
        <?php foreach ($lists as $index => $item) :

          $icon              = $item['tj_menu_icon'] ?? [];
          $menu_item         = $item['tj_menu_item'] ?? '';
          $link_type         = $item['tj_menu_link_type'] ?? '1';
          $custom_link       = $item['tj_menu_link'] ?? '';
          $page_link  = $item['tj_menu_page_link'] ?? '';

          // Link setup
          $link_attrs = "tj_menu_arg_{$index}";

          if ($link_type == '2' && !empty($page_link)) {
            $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
            $this->add_render_attribute($link_attrs, 'target', '_self');
            $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
          } elseif (!empty($custom_link['url'])) {
            $this->add_link_attributes($link_attrs, $custom_link);
          }
        ?>
          <li>
            <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
              <?php if (!empty($icon['value'])) : ?>
                <?php tj_render_icon($item, 'menu_icon', 'tj_menu_icon'); ?>
              <?php endif; ?>
              <?php echo tj_kses($menu_item, 'tjcore'); ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>
</div>