<?php
$tjSelectForm     = $settings['tj_select_form'] ?? '';

$tjSectionTitle   = $settings['tj_title'] ?? "";
$tjSectionTitleTag   = $settings['tj_title_tag'] ?? "h3";
// animation
$tj_gsap_animation   = $settings['tj_gsap_animation'] ?? '';
$tjGsapAnimationType   = $settings['animation_type'] ?? '';
$tjTitleAnimation   = $settings['tj_title_animation'] ?? '';
$tjTitleAnimationName   = $settings['tj_title_animation_name'] ?? '';
$tjTitleAnimationDelay   = $settings['tj_title_animation_delay'] ?? '';
if (!empty($tjTitleAnimation)) {
  $titleClass = "title tj-el-title wow $tjTitleAnimationName";
  $this->add_render_attribute('title_args', 'data-wow-delay', $tjTitleAnimationDelay['size'] . "s");
} elseif (!empty($tj_gsap_animation) || !empty($tjGsapAnimationType)) {
  $titleClass = "title tj-el-title $tjGsapAnimationType";
} else {
  $titleClass = "title tj-el-title";
}
$this->add_render_attribute('title_args', 'class', $titleClass);

// Animation settings
$tjAnimation      = $settings['tj_animation'] ?? '';
$tjAnimationName  = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay = $settings['tj_animation_delay']['size'] ?? '';

// Initialize wrapper class
$formClass = 'contact-form m-0 tj-el-form';

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
  $formClass .= ' wow ' . esc_attr($tjAnimationName);

  if (!empty($tjAnimationDelay)) {
    $this->add_render_attribute('tj_form_arg', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
  }
}

$this->add_render_attribute('tj_form_arg', 'class', esc_attr($formClass));
?>

<div <?php echo $this->get_render_attribute_string('tj_form_arg'); ?>>

  <?php
  if (!empty($tjSectionTitle)) :
    printf(
      '<%1$s %2$s>%3$s</%1$s>',
      tag_escape($tjSectionTitleTag),
      $this->get_render_attribute_string('title_args'),
      tj_kses($tjSectionTitle)
    );
  endif;
  ?>

  <div id="contact-form">
    <?php
    if (!empty($tjSelectForm)) {
      echo do_shortcode('[contact-form-7 id="' . esc_attr($tjSelectForm) . '"]');
    } else {
      echo '<p>' . esc_html__('Select Contact Form', 'tjcore') . '</p>';
    }
    ?>
  </div>

</div>