<?php

$content_items     = $settings['tj_content_list'] ?? [];
$image         = $settings['tj_image']['url'] ?? '';
$image_id      = $settings['tj_image']['id'] ?? '';


$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Initialize wrapper class
$wrapperClass = 'global-map';

if (!empty($tjAnimation) && !empty($tjAnimationName)) {
    $wrapperClass .= ' wow ' . esc_attr($tjAnimationName);

    if (!empty($tjAnimationDelay)) {
        $this->add_render_attribute('tj_wrap_attr', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
    }
}
$this->add_render_attribute('tj_wrap_attr', 'class', esc_attr($wrapperClass));

?>


<div <?php echo $this->get_render_attribute_string('tj_wrap_attr'); ?>>
    <div class="global-map-img">
        <?php if (!empty($image)) : ?>
            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
        <?php endif; ?>
        <?php foreach ($content_items as $index => $item) :
            $tj_map_content  = $item['tj_map_content'] ?? '';
            $tj_class_name  = $item['tj_class_name'] ?? '';
        ?>
            <?php if (!empty($tj_map_content)) : ?>
                <div class="location-indicator <?php echo esc_attr($tj_class_name); ?>">
                    <div class="location-tooltip tj-el-box">
                        <?php echo tj_kses($tj_map_content); ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</div>