<?php
$iconBoxTitle     = $settings['tj_iconbox_title'] ?? '';
$iconBoxLink      = $settings['tj_iconbox_link'] ?? '';
$iconBoxDesc      = $settings['tj_iconbox_desc'] ?? '';

$link   = $iconBoxLink['url'] ?? '';
$target = !empty($iconBoxLink['is_external']) ? '_blank' : '';
$rel    = !empty($iconBoxLink['nofollow']) ? 'nofollow' : '';

$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$itemClass = "choose-box h6-choose-box tj-el-box";
if (!empty($tjAnimation)) {
  $itemClass .= " wow " . esc_attr($tjAnimationName);
  $this->add_render_attribute('tj_iconbox_arg', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}

$this->add_render_attribute('tj_iconbox_arg', 'class', $itemClass);
?>

<div <?php echo $this->get_render_attribute_string('tj_iconbox_arg'); ?>>
  <div class="choose-content">
    <?php if (!empty($settings['tj_iconbox_icon']['value'])) : ?>
      <div class="choose-icon tj-el-icon">
        <?php tj_render_icon($settings, 'tj_icon', 'tj_iconbox_icon'); ?>
      </div>
    <?php endif; ?>

    <?php if (!empty($iconBoxTitle)) : ?>
      <h4 class="title tj-el-title">
        <?php if (!empty($link)) : ?>
          <a href="<?php echo esc_url($link); ?>" <?php if ($target) echo 'target="' . esc_attr($target) . '"'; ?> <?php if ($rel) echo 'rel="' . esc_attr($rel) . '"'; ?>>
            <?php echo tj_kses($iconBoxTitle); ?>
          </a>
        <?php else : ?>
          <?php echo tj_kses($iconBoxTitle); ?>
        <?php endif; ?>
      </h4>
    <?php endif; ?>

    <?php if (!empty($iconBoxDesc)) : ?>
      <p class="desc tj-el-desc">
        <?php echo tj_kses($iconBoxDesc); ?>
      </p>
    <?php endif; ?>
  </div>
</div>