<?php

$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($settings['image']['id'], 'image_size', $settings);
if (empty($image_url)) {
  $image_url = \Elementor\Utils::get_placeholder_image_src();
}

$this->add_render_attribute('title', 'class', 'customers-text tj-el-title');
$title_html = sprintf('<%1$s %2$s>%3$s</%1$s>', $title_tag, $this->get_render_attribute_string('title'), $title);
if (!empty($settings['link']['url'])) {
  $this->add_link_attributes('link', $settings['link']);
  $title_html = sprintf('<%1$s %2$s><a ' . $this->get_render_attribute_string('link') . '>%3$s</a></%1$s>', $title_tag, $this->get_render_attribute_string('title'), $title);
}


$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$animation_class = '';
$animation_attr  = '';

if ($tjAnimation === 'yes') {
  $animation_class = 'wow ' . esc_attr($tjAnimationName);
  $animation_attr  = ' data-wow-delay="' . esc_attr($tjAnimationDelay) . 's"';
}

?>

<div class="customers-box tj-el-imagebox style-2 <?php echo esc_attr($animation_class); ?>" <?php echo $animation_attr; ?>>
  <!-- image -->
  <?php if (!empty($settings['image']['url'])) : ?>
    <div class="customers-bg" data-bg-image="<?php echo esc_attr($image_url); ?>"></div>
  <?php endif; ?>
  <!-- content -->
  <?php if (!empty($settings['desc'])) {
    echo '<div class="customers tj-el-desc">' . $settings['desc'] . '</div>';
  } ?>
  <!-- title -->
  <?php if (!empty($settings['title'])) {
    echo $title_html;
  } ?>

  <div class="star-icon zoomInOut"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/star.svg" alt=""></div>

</div>