<?php
$lists = !empty($settings['tj_menu_list']) ? $settings['tj_menu_list'] : [];
?>

<div class="mega-menu-wrapper">
    <?php if (!empty($lists)) : ?>
        <div class="row rg-30">
            <?php foreach ($lists as $index => $item) :
                $icon = $item['tj_menu_icon'] ?? '';
                $menuItem = $item['tj_menu_item'] ?? '';
                $menuBtn = $item['tj_menu_btn'] ?? '';
                $image = $item['tj_demo_image'] ?? [];

                $tj_badge = $item['tj_badge'] ?? '';
                $tj_menu_badge = $item['tj_menu_badge'] ?? '';

                $link_key = 'tj_menu_arg_' . $index;
                $tj_menu_link_type = $item['tj_menu_link_type'] ?? '';
                $tj_menu_link = $item['tj_menu_link'] ?? [];
                $tj_menu_page_link = $item['tj_menu_page_link'] ?? '';

                if ($tj_menu_link_type === '2' && $tj_menu_page_link) {
                    $this->add_render_attribute($link_key, 'href', get_permalink($tj_menu_page_link));
                    $this->add_render_attribute($link_key, 'target', '_self');
                    $this->add_render_attribute($link_key, 'rel', 'nofollow');
                } elseif (!empty($tj_menu_link['url'])) {
                    $this->add_link_attributes($link_key, $tj_menu_link);
                }

                $img_url = $image['url'] ?? '';
                $img_alt = isset($image['id']) ? get_post_meta($image['id'], '_wp_attachment_image_alt', true) : '';
            ?>
                <div class="col-xl-3 col-lg-3 col-12">
                    <div class="tj-demo-thumb">
                        <?php if ($img_url) : ?>
                            <div class="image">
                                <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>" />
                                <?php if ($tj_badge && $tj_menu_badge) : ?>
                                    <h6 class="tj-demo-badge tj-zoom-in-out-anim"><?php echo tj_kses($tj_menu_badge); ?></h6>
                                <?php endif; ?>

                                <?php if ($menuBtn) : ?>
                                    <div class="tj-demo-button">
                                        <a <?php echo $this->get_render_attribute_string($link_key); ?> class="tj-primary-btn header_btn">
                                            <span class="btn-text"><span><?php echo tj_kses($menuBtn); ?></span></span>
                                            <?php if (!empty($icon['value'])) : ?>
                                                <span class="btn-icon">
                                                    <?php tj_render_icon($item, 'menu_icon', 'tj_menu_icon'); ?>
                                                </span>
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($menuItem) : ?>
                            <h6 class="tj-demo-title">
                                <a <?php echo $this->get_render_attribute_string($link_key); ?>>
                                    <?php echo tj_kses($menuItem); ?>
                                </a>
                            </h6>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>