<?php
$lists = !empty($settings['tj_menu_list']) ? $settings['tj_menu_list'] : [];
?>



<?php if (!empty($lists)) : ?>
    <div class="mega-menu-service">
        <?php foreach ($lists as $index => $item) :
            $icon = $item['tj_menu_icon'] ?? '';
            $menuItem = $item['tj_menu_item'] ?? '';
            $menuBtn = $item['tj_menu_btn'] ?? '';

            $link_key = 'tj_menu_arg_' . $index;
            $tj_menu_link_type = $item['tj_menu_link_type'] ?? '';
            $tj_menu_link = $item['tj_menu_link'] ?? [];
            $tj_menu_page_link = $item['tj_menu_page_link'] ?? '';

            if ($tj_menu_link_type === '2' && $tj_menu_page_link) {
                $this->add_render_attribute($link_key, 'href', get_permalink($tj_menu_page_link));
                $this->add_render_attribute($link_key, 'target', '_self');
                $this->add_render_attribute($link_key, 'rel', 'nofollow');
            } elseif (!empty($tj_menu_link['url'])) {
                $this->add_link_attributes($link_key, $tj_menu_link);
            }

        ?>
            <a class="mega-menu-service-single" <?php echo $this->get_render_attribute_string($link_key); ?>>
                <?php if (!empty($icon['value'])) : ?>
                    <span class="mega-menu-service-icon">
                        <?php tj_render_icon($item, 'menu_icon', 'tj_menu_icon'); ?>
                    </span>
                <?php endif; ?>
                <?php if ($menuItem) : ?>
                    <span class="mega-menu-service-title"> <?php echo tj_kses($menuItem); ?></span>
                <?php endif; ?>
                <?php if ($menuBtn) : ?>
                    <span class="mega-menu-service-nav"><?php echo tj_kses($menuBtn); ?><?php echo tj_kses($menuBtn); ?></span>
                <?php endif; ?>
            </a>
        <?php endforeach; ?>
    </div>

<?php endif; ?>