<?php
$accordionList     = $settings['tj_accordion_list'] ?? [];
$accordion_id      = $this->get_id(); // unique ID for this accordion instance
?>

<div class="accordion tj-faq pricing-accordion" id="pricingAccordion-<?php echo esc_attr($accordion_id); ?>">

  <?php foreach ($accordionList as $index => $item) :
    $priceTitle     = $item['price_title'] ?? "";
    $priceDesc     = $item['price_description'] ?? "";

    $priceCurrency     = $item['tj_price_currency'] ?? "";
    $priceCurrencyCustom     = $item['tj_currency_custom'] ?? "";
    $pricePrice     = $item['tj_price'] ?? "";
    $pricePeriod     = $item['tj_price_period'] ?? "";

    if ($priceCurrency === 'custom') {
      $currency = $priceCurrencyCustom;
    } else {
      $currency = self::get_currency_symbol($priceCurrency);
    }

    $priceFeatures     = $item['tj_price_features'] ?? "";

    $priceBtnText     = $item['tj_btn_text'] ?? "";
    $priceBtnLinkType     = $item['tj_btn_link_type'] ?? "";
    $priceBtnLink     = $item['tj_btn_link'] ?? "";
    $priceBtnPageLink     = $item['tj_btn_page_link'] ?? "";

    // link setup
    $link_attrs = "price_btn_link_{$index}";

    if ($priceBtnLinkType == '2' && !empty($priceBtnPageLink)) {
      $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($priceBtnPageLink)));
      $this->add_render_attribute($link_attrs, 'target', '_self');
      $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
    } elseif (!empty($priceBtnLink['url'])) {
      $this->add_link_attributes($link_attrs, $priceBtnLink);
    }

    $is_expand       = $item['is_expand'] === 'yes';
    $itemAnim        = $item['tj_animation'] ?? '';
    $itemAnimName    = $item['tj_animation_name'] ?? '';
    $itemDelay       = $item['tj_animation_delay']['size'] ?? '';

    $collapse_id     = 'pricing-' . esc_attr($accordion_id . '-' . $index);
    $show_class      = $is_expand ? 'show' : '';
    $expanded        = $is_expand ? 'true' : 'false';
    $button_class    = $is_expand ? 'collapsed' : '';
    $item_class      = 'accordion-item pricing-box';
    $item_attrs      = '';

    if ($is_expand) {
      $item_class .= ' active';
    }
    if ($itemAnim === 'yes') {
      $item_class .= ' wow ' . esc_attr($itemAnimName);
      $item_attrs = ' data-wow-delay="' . esc_attr($itemDelay) . 's"';
    }
  ?>
    <div class="<?php echo esc_attr($item_class); ?>" <?php echo $item_attrs; ?>>
      <button class="faq-title <?php echo esc_attr($button_class); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo esc_attr($collapse_id); ?>"
        aria-expanded="<?php echo esc_attr($expanded); ?>">
        <?php echo tj_kses($priceTitle); ?>
      </button>

      <div id="<?php echo esc_attr($collapse_id); ?>" class="collapse <?php echo esc_attr($show_class); ?>" data-bs-parent="#pricingAccordion-<?php echo esc_attr($accordion_id); ?>">
        <div class="accordion-body pricing-inner">
          <div class="pricing-header">
            <div class="pricing-top">
              <?php if (!empty($priceDesc)): ?>
                <div class="package-desc">
                  <p><?php echo tj_kses($priceDesc); ?></p>
                </div>
              <?php endif; ?>

              <?php if (!empty($pricePrice)): ?>
                <div class="package-price">
                  <?php if (!empty($currency)): ?>
                    <span class="package-currency"><?php echo esc_attr($currency) ?></span>
                  <?php endif; ?>
                  <span class="price-number"><?php echo esc_html($pricePrice, 'tjcore'); ?></span>
                  <?php if (!empty($pricePeriod)): ?>
                    <span class="package-period"><?php echo tj_kses($pricePeriod, 'tjcore'); ?></span>
                  <?php endif; ?>
                </div>
              <?php endif; ?>
            </div>


            <?php if (!empty($priceBtnText)): ?>
              <div class="pricing-btn">
                <a class="text-btn" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                  <span class="btn-text"><span><?php echo esc_html__($priceBtnText, 'tjcore'); ?></span></span>
                  <?php if (!empty($item['tj_btn_icon']['value'])): ?>
                    <span class="btn-icon"><?php tj_render_icon($item, 'btn_icon', 'tj_btn_icon') ?></span>
                  <?php endif; ?>
                </a>
              </div>
            <?php endif; ?>

          </div>

          <?php if (!empty($priceFeatures)): ?>
            <div class="list-items">
              <?php echo tj_kses($priceFeatures); ?>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>