<?php
$tj_process_list = $settings['tj_process_list'] ?? [];
$tj_number_show = $settings['tj_number_show'] ?? '';
?>

<div class="h5-working-process-inner">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="working-process-area h5-working-process-wrapper">

          <?php foreach ($tj_process_list as $index => $item) :
            $title = $item['tj_process_title'] ?? '';
            $text = $item['tj_process_text'] ?? '';

            // Animation attributes
            $tjAnimation       = $item['tj_animation'] ?? '';
            $tjAnimationName   = $item['tj_animation_name'] ?? '';
            $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
            $process_attr_key  = 'process_item_attr_' . $index;

            $process_class = 'process-item h5-working-process-item tj-el-process';
            if (!empty($tjAnimation)) {
              $process_class .= ' wow ' . esc_attr($tjAnimationName);
              $this->add_render_attribute($process_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
            }

            $this->add_render_attribute($process_attr_key, 'class', $process_class);

          ?>
            <div <?php echo $this->get_render_attribute_string($process_attr_key); ?>>
              <h5 class="h5-working-process-indicator tj-el-indicator"><?php echo esc_html__('Step', 'tjcore'); ?> <?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT); ?></h5>
              <?php if (!empty($tj_number_show)) : ?>
                <div class="process-step tj-el-number">
                  <span><?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT); ?></span>
                </div>
              <?php endif; ?>
              <div class="process-content">
                <?php if (!empty($title)) : ?>
                  <h4 class="title tj-el-title"> <?php echo tj_kses($title); ?></h4>
                <?php endif; ?>
                <?php if (!empty($text)) : ?>
                  <p class="desc tj-el-desc"><?php echo tj_kses($text); ?></p>
                <?php endif; ?>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>
</div>