<?php
$tj_process_list = $settings['tj_process_list'] ?? [];
$tj_number_show = $settings['tj_number_show'] ?? '';
?>

<div class="h6-working-process-wrapper">

  <?php foreach ($tj_process_list as $index => $item) :
    $title = $item['tj_process_title'] ?? '';
    $text = $item['tj_process_text'] ?? '';

    // Animation attributes
    $tjAnimation       = $item['tj_animation'] ?? '';
    $tjAnimationName   = $item['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
    $process_attr_key  = 'process_item_attr_' . $index;

    $process_class = 'process-item h6-working-process-item tj-hover-active-item tj-el-process';

    if ($index === 0) {
      $process_class .= ' active';
    }

    if (!empty($tjAnimation)) {
      $process_class .= ' wow ' . esc_attr($tjAnimationName);
      $this->add_render_attribute($process_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
    }

    $this->add_render_attribute($process_attr_key, 'class', $process_class);

  ?>
    <div <?php echo $this->get_render_attribute_string($process_attr_key); ?>>
      <?php if (!empty($tj_number_show)) : ?>
        <div class="process-step tj-el-number">
          <span><?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT); ?><?php echo esc_html__('.', 'tjcore'); ?></span>
        </div>
      <?php endif; ?>
      <div class="process-content">
        <?php if (!empty($title)) : ?>
          <h4 class="title tj-el-title"> <?php echo tj_kses($title); ?></h4>
        <?php endif; ?>
        <?php if (!empty($text)) : ?>
          <p class="desc tj-el-desc"><?php echo tj_kses($text); ?></p>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>

</div>