<?php
$tjProjectInfoList = $settings['project_info_list'] ?? [];
$tjSectionTitle = $settings['tj_section_title'] ?? '';

// animation
$tjAnimation   = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

$class = "tj-sidebar-widget mb-0";
if (!empty($tjAnimation)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_project_info_args', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
}
$this->add_render_attribute('tj_project_info_args', 'class', $class);

?>

<?php if (!empty($tjProjectInfoList)): ?>

  <div class="tj-careers-details">
    <div <?php echo $this->get_render_attribute_string('tj_project_info_args'); ?>>
      <?php if (!empty($tjSectionTitle)): ?>
        <h4 class="widget-title"><?php echo tj_kses($tjSectionTitle); ?></h4>
      <?php endif; ?>
      <div class="project_catagory">
        <ul>
          <?php foreach ($tjProjectInfoList as $item):
            $subtitle = $item['tj_project_info_subtitle'] ?? '';
            $title = $item['tj_project_info_title'] ?? '';
          ?>
            <li>
              <?php if (!empty($subtitle)): ?>
                <span class="first-child"><?php echo esc_html__($subtitle, 'tjcore'); ?></span>
              <?php endif; ?>
              <?php if (!empty($title)): ?>
                <span><?php echo tj_kses($title); ?></span>
              <?php endif; ?>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  </div>

<?php endif; ?>