<?php

// Repeater list
$project_items = $settings['tj_project_list'] ?? [];

?>


<div class="project-wrapper h7-project-wrapper">
  <?php foreach ($project_items as $index => $item) :

    $image         = $item['tj_project_image']['url'] ?? '';
    $image_id      = $item['tj_project_image']['id'] ?? '';
    $title         = $item['tj_project_title'] ?? '';
    $category      = $item['tj_project_cat'] ?? '';
    $category_link = $item['tj_project_cat_link'] ?? [];
    $btn_icon      = $item['tj_project_btn_icon'] ?? [];
    $link_type     = $item['tj_project_link_type'] ?? '1';
    $custom_link   = $item['tj_project_link'] ?? [];
    $page_link     = $item['tj_project_page_link'] ?? '';

    // link setup
    $link_attrs = "project_link_{$index}";

    if ($link_type == '2' && !empty($page_link)) {
      $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
      $this->add_render_attribute($link_attrs, 'target', '_self');
      $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
    } elseif (!empty($custom_link['url'])) {
      $this->add_link_attributes($link_attrs, $custom_link);
    }

    // Animation attributes
    $tjAnimation       = $item['tj_animation'] ?? '';
    $tjAnimationName   = $item['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
    $project_attr_key  = 'project_item_attr_' . $index;

    $project_class = 'project-item h4-project-item tj-sticky-panel tj-el-project';

    if (!empty($tjAnimation)) {
      $project_class .= ' wow ' . esc_attr($tjAnimationName);
      $this->add_render_attribute($project_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
    }

    $this->add_render_attribute($project_attr_key, 'class', $project_class);

  ?>
    <div <?php echo $this->get_render_attribute_string($project_attr_key); ?>>

      <?php if (!empty($image)) : ?>
        <div class="project-img">
          <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
        </div>
      <?php endif; ?>
      <div class="project-content">
        <div class="project-text">
          <div>
            <?php if (!empty($title)) : ?>
              <h3 class="title tj-el-title">
                <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                  <?php echo tj_kses($title); ?>
                </a>
              </h3>
            <?php endif; ?>
            <?php if (!empty($category)) : ?>
              <span class="categories">
                <?php if (!empty($category_link['url'])) : ?>
                  <a class="tj-el-cat" href="<?php echo esc_url($category_link['url']); ?>"><?php echo tj_kses($category); ?></a>
                <?php else: ?>
                  <span class="tj-el-cat"><?php echo tj_kses($category); ?></span>
                <?php endif; ?>
              </span>
            <?php endif; ?>
          </div>
          <?php if (!empty($btn_icon['value'])) : ?>
            <a class="tji-icon-btn tj-el-icon-btn" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
              <?php tj_render_icon($item, 'btn_icon', 'tj_project_btn_icon'); ?>
            </a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>