<?php

// Repeater list
$project_items = $settings['tj_project_list'] ?? [];


$slide_loop           = $settings['slide_loop'] ?? '';
$slide_nav            = $settings['slide_nav'] ?? '';
$slide_dot            = $settings['slide_dot'] ?? '';
$slide_autoplay       = $settings['slide_autoplay'] ?? '';
$slide_autoplay_delay = $settings['slide_autoplay_Delay'] ?? 5000;

// Animation attributes
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

$wrapper_class = 'project-wrapper h9-project-wrapper carouselWrap';
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $wrapper_class .= ' wow ' . esc_attr($tjAnimationName);
  $this->add_render_attribute('wrapper_attr', 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
}
$this->add_render_attribute('wrapper_attr', 'class', $wrapper_class);
?>


<div <?php echo $this->get_render_attribute_string('wrapper_attr'); ?> data-loop="<?php echo $slide_loop; ?>" data-nav="<?php echo $slide_nav; ?>" data-dot="<?php echo $slide_dot; ?>" data-autoplay="<?php echo $slide_autoplay; ?>" data-delay="<?php echo $slide_autoplay_delay; ?>">
  <div class="swiper h9-project-slider " id="projectSlider-<?php echo $this->get_id(); ?>">
    <div class="swiper-wrapper">
      <?php foreach ($project_items as $index => $item) :

        $image         = $item['tj_project_image']['url'] ?? '';
        $image_id      = $item['tj_project_image']['id'] ?? '';
        $title         = $item['tj_project_title'] ?? '';
        $category      = $item['tj_project_cat'] ?? '';
        $category_link = $item['tj_project_cat_link'] ?? [];
        $btn_icon      = $item['tj_project_btn_icon'] ?? [];
        $link_type     = $item['tj_project_link_type'] ?? '1';
        $custom_link   = $item['tj_project_link'] ?? [];
        $page_link     = $item['tj_project_page_link'] ?? '';

        // Link setup
        $link_attrs = "project_link_{$index}";

        if ($link_type == '2' && !empty($page_link)) {
          $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
          $this->add_render_attribute($link_attrs, 'target', '_self');
          $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
        } elseif (!empty($custom_link['url'])) {
          $this->add_link_attributes($link_attrs, $custom_link);
        }
      ?>
        <div class="swiper-slide">
          <div class="project-item">
            <?php if (!empty($image)) : ?>
              <div class="project-img">
                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
              </div>
            <?php endif; ?>

            <div class="project-content tj-el-project">
              <?php if (!empty($category)) : ?>
                <span class="categories">
                  <?php if (!empty($category_link['url'])) : ?>
                    <a class="tj-el-cat" href="<?php echo esc_url($category_link['url']); ?>"><?php echo tj_kses($category); ?></a>
                  <?php else: ?>
                    <span class="tj-el-cat"><?php echo tj_kses($category); ?></span>
                  <?php endif; ?>
                </span>
              <?php endif; ?>

              <div class="project-text">
                <?php if (!empty($title)) : ?>
                  <h4 class="title tj-el-title">
                    <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                      <?php echo tj_kses($title); ?>
                    </a>
                  </h4>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>

    </div>
    <?php if (!empty($slide_dot) && $slide_dot === 'yes') : ?>
      <div class="swiper-pagination-area"></div>
    <?php endif; ?>
  </div>
</div>