<?php

// Repeater list
$service_items = $settings['tj_service_list'] ?? [];

?>


<div class="h9-service-scroll-progress tj-scroll-progress tj-sticky-panel-2">
  <?php foreach ($service_items as $index => $item) :

    $progress_class = 'tj-scroll-progress-item';
    if ($index === 0) {
      $progress_class .= ' active';
    }
  ?>
    <div class="<?php echo esc_attr($progress_class); ?>">
      <h5 class="tj-scroll-progress-sln"><?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT), esc_html__('.', 'tjcore'); ?></h5>
      <div class="tj-scroll-progress-ind">
        <div class="tj-scroll-progress-ind-inner"></div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<div class="service-wrapper h9-service-wrapper">
  <?php foreach ($service_items as $index => $item) :

    $icon          = $item['tj_service_icon'] ?? [];
    $image         = $item['tj_service_image'] ?? '';
    $image_id      = $item['tj_service_image']['id'] ?? '';
    $title         = $item['tj_service_title'] ?? '';
    $desc          = $item['tj_service_desc'] ?? '';
    $button        = $item['tj_service_btn'] ?? '';
    $btn_icon      = $item['tj_service_btn_icon'] ?? [];
    $link_type     = $item['tj_service_link_type'] ?? '1';
    $custom_link   = $item['tj_service_link'] ?? [];
    $page_link     = $item['tj_service_page_link'] ?? '';

    // Link setup
    $link_attrs = "service_link_{$index}";

    if ($link_type == '2' && !empty($page_link)) {
      $this->add_render_attribute($link_attrs, 'href', esc_url(get_permalink($page_link)));
      $this->add_render_attribute($link_attrs, 'target', '_self');
      $this->add_render_attribute($link_attrs, 'rel', 'nofollow');
    } elseif (!empty($custom_link['url'])) {
      $this->add_link_attributes($link_attrs, $custom_link);
    }

    $tjAnimation       = $item['tj_animation'] ?? '';
    $tjAnimationName   = $item['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $item['tj_animation_delay']['size'] ?? '';
    $service_attr_key  = 'service_item_attr_' . $index;

    $service_class = 'service-item style-5 tj-progress-item tj-el-service';

    if (!empty($tjAnimation)) {
      $service_class .= ' wow ' . esc_attr($tjAnimationName);
      $this->add_render_attribute($service_attr_key, 'data-wow-delay', esc_attr($tjAnimationDelay) . 's');
    }

    $this->add_render_attribute($service_attr_key, 'class', $service_class);

  ?>
    <div <?php echo $this->get_render_attribute_string($service_attr_key); ?>>
      <div class="service-content-area">
        <?php if (!empty($icon['value'])) : ?>
          <div class="service-icon tj-el-icon">
            <?php tj_render_icon($item, 'service_icon', 'tj_service_icon'); ?>
          </div>
        <?php endif; ?>
        <div class="service-content">
          <?php if (!empty($title)) : ?>
            <h4 class="title tj-el-title">
              <a <?php echo $this->get_render_attribute_string($link_attrs); ?>>
                <?php echo esc_html($title); ?>
              </a>
            </h4>
          <?php endif; ?>
          <?php if (!empty($desc)) : ?>
            <p class="desc tj-el-desc">
              <?php echo tj_kses($desc); ?>
            </p>
          <?php endif; ?>
        </div>

        <?php if (!empty($btn_icon['value'])) : ?>
          <a class="h9-service-nav tj-el-btn" <?php echo $this->get_render_attribute_string($link_attrs); ?>>
            <span class="btn-icon"><?php tj_render_icon($item, 'btn_icon', 'tj_service_btn_icon'); ?></span>
          </a>
        <?php endif; ?>
      </div>
      <?php if (!empty($image['url'])) : ?>
        <div class="service-img">
          <img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
        </div>
      <?php endif; ?>
    </div>
  <?php endforeach; ?>
</div>