<?php
$reviewList        = $settings['tj_testi_list'] ?? [];
$loop              = $settings['slide_loop'] ?? 'no';
$nav               = $settings['slide_nav'] ?? 'no';
$autoplay          = $settings['slide_autoplay'] ?? 'no';
$autoplayDelay     = $settings['slide_autoplay_Delay'] ?? 5000;

$tj_heading       = $settings['tj_heading'] ?? '';
$tjAnimation       = $settings['tj_animation'] ?? '';
$animationName     = $settings['tj_animation_name'] ?? '';
$animationDelay    = $settings['tj_animation_delay']['size'] ?? '';
$quoteIcon         = $settings['tj_quote_icon']['value'] ?? '';

$wrapperClass      = 'carouselWrap testimonial-wrapper-3';
if ($tjAnimation === 'yes' && !empty($animationName)) {
  $wrapperClass .= ' wow ' . esc_attr($animationName);
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', esc_attr($animationDelay) . 's');
}

$this->add_render_attribute('tj-testimonial-arg', 'class', $wrapperClass);

$is_rtl = is_rtl() ? 'rtl' : 'ltr';
?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?>
  data-loop="<?php echo esc_attr($loop); ?>"
  data-nav="<?php echo esc_attr($nav); ?>"
  data-autoplay="<?php echo esc_attr($autoplay); ?>"
  data-delay="<?php echo esc_attr($autoplayDelay); ?>">

  <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper  testimonial-slider-2 h4-testimonial tj-el-wrapper" id="testiCarousel-<?php echo $this->get_id(); ?>">

    <?php if (!empty($tj_heading)): ?>
      <h3 class="tes-title tj-el-heading"><?php echo tj_kses($tj_heading); ?></h3>
    <?php endif; ?>

    <div class="swiper-wrapper">

      <?php foreach ($reviewList as $review) :
        $image       = $review['tj_testi_image']['url'] ?? '';
        $name        = $review['tj_testi_name'] ?? '';
        $designation = $review['tj_testi_designation'] ?? '';
        $text        = $review['tj_testi_text'] ?? '';
      ?>
        <div class="swiper-slide">
          <div class="testimonial-item tj-el-card">
            <?php if (!empty($quoteIcon)) : ?>
              <span class="quote-icon tj-el-icon">
                <?php tj_render_icon($settings, 'quote_icon', 'tj_quote_icon'); ?>
              </span>
            <?php endif; ?>

            <?php if (!empty($text)) : ?>
              <div class="desc">
                <p class="tj-el-desc"><?php echo tj_kses($text); ?></p>
              </div>
            <?php endif; ?>

            <div class="testimonial-author">
              <div class="author-inner">
                <?php if (!empty($image)) : ?>
                  <div class="author-img tj-el-image">
                    <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($name); ?>">
                  </div>
                <?php endif; ?>
                <div class="author-header">
                  <?php if (!empty($name)) : ?>
                    <h4 class="title tj-el-title"><?php echo tj_kses($name); ?></h4>
                  <?php endif; ?>
                  <?php if (!empty($designation)) : ?>
                    <span class="designation tj-el-desig"><?php echo tj_kses($designation); ?></span>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>

    </div>

    <?php if ($nav === 'yes') : ?>
      <div class="testimonial-navigation d-flex">
        <div class="slider-prev">
          <span class="anim-icon">
            <i class="tji-arrow-left"></i>
            <i class="tji-arrow-left"></i>
          </span>
        </div>
        <div class="slider-next">
          <span class="anim-icon">
            <i class="tji-arrow-right"></i>
            <i class="tji-arrow-right"></i>
          </span>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>