<?php
$reviewList        = $settings['tj_testi_list'] ?? [];
$loop              = $settings['slide_loop'] ?? 'no';
$dots              = $settings['slide_dot'] ?? 'no';
$nav               = $settings['slide_nav'] ?? 'no';
$autoplay          = $settings['slide_autoplay'] ?? 'no';
$autoplayDelay     = $settings['slide_autoplay_Delay'] ?? 5000;

$tjAnimation       = $settings['tj_animation'] ?? '';
$animationName     = $settings['tj_animation_name'] ?? '';
$animationDelay    = $settings['tj_animation_delay']['size'] ?? '';
$quoteIcon         = $settings['tj_quote_icon']['value'] ?? '';

$wrapperClass      = 'carouselWrap testimonial-wrapper h6-testimonial-wrapper';
if ($tjAnimation === 'yes' && !empty($animationName)) {
  $wrapperClass .= ' wow ' . esc_attr($animationName);
  $this->add_render_attribute('tj-testimonial-arg', 'data-wow-delay', esc_attr($animationDelay) . 's');
}

$this->add_render_attribute('tj-testimonial-arg', 'class', $wrapperClass);

$is_rtl = is_rtl() ? 'rtl' : 'ltr';
?>

<div <?php echo $this->get_render_attribute_string('tj-testimonial-arg'); ?>
  data-loop="<?php echo esc_attr($loop); ?>"
  data-nav="<?php echo esc_attr($nav); ?>"
  data-dot="<?php echo esc_attr($dots); ?>"
  data-autoplay="<?php echo esc_attr($autoplay); ?>"
  data-delay="<?php echo esc_attr($autoplayDelay); ?>">
  <div dir="<?php echo esc_attr($is_rtl); ?>" class="swiper  h6-testimonial-slider" id="testiCarousel-<?php echo $this->get_id(); ?>">
    <div class="swiper-wrapper">

      <?php foreach ($reviewList as $review) :
        $image       = $review['tj_testi_image']['url'] ?? '';
        $name        = $review['tj_testi_name'] ?? '';
        $designation = $review['tj_testi_designation'] ?? '';
        $text        = $review['tj_testi_text'] ?? '';
      ?>
        <div class="swiper-slide">
          <div class="testimonial-item tj-el-card">
            <div class="h6-testimonial-author-wrapper">
              <div class="testimonial-author">
                <div class="author-inner">
                  <?php if (!empty($image)) : ?>
                    <div class="author-img tj-el-image">
                      <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($name); ?>">
                    </div>
                  <?php endif; ?>

                  <div class="author-header">
                    <?php if (!empty($name)) : ?>
                      <h4 class="title tj-el-title"><?php echo tj_kses($name); ?></h4>
                    <?php endif; ?>

                    <?php if (!empty($designation)) : ?>
                      <span class="designation tj-el-desig"><?php echo tj_kses($designation); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>

              <?php if (!empty($review['tj_testi_rating'])) : ?>
                <div class="star-ratings el-rating">
                  <div class="fill-ratings" style="width: <?php echo esc_attr($review['tj_testi_rating']['size']);
                                                          echo esc_attr($review['tj_testi_rating']['unit']) ?>">
                    <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                  </div>
                  <div class="empty-ratings">
                    <span><?php esc_html_e('★★★★★', 'tjcore'); ?></span>
                  </div>
                </div>
              <?php endif; ?>
            </div>
            <?php if (!empty($text)) : ?>
              <div class="desc">
                <p class="tj-el-desc"><?php echo tj_kses($text); ?></p>
              </div>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>