<?php

$loop              = $settings['slide_loop'] ?? 'no';
$dots              = $settings['slide_dot'] ?? 'no';
$autoplay          = $settings['slide_autoplay'] ?? 'no';
$autoplayDelay     = $settings['slide_autoplay_Delay'] ?? 5000;

// Animation
$tjAnimation       = $settings['tj_animation'] ?? '';
$tjAnimationName   = $settings['tj_animation_name'] ?? '';
$tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

// Setting animation attributes
$class = "h6-hero-card-wrapper tj-el-card carouselWrap";
if ($tjAnimation === 'yes' && !empty($tjAnimationName)) {
  $class .= " wow $tjAnimationName";
  $this->add_render_attribute('tj_video_args', 'data-wow-delay', $tjAnimationDelay . 's');
}
$this->add_render_attribute('tj_video_args', 'class', $class);
?>

<div <?php echo $this->get_render_attribute_string('tj_video_args'); ?> data-loop="<?php echo esc_attr($loop); ?>" data-dot="<?php echo esc_attr($dots); ?>" data-autoplay="<?php echo esc_attr($autoplay); ?>" data-delay="<?php echo esc_attr($autoplayDelay); ?>">
  <div class="swiper h6-hero-card-slider" id="videoCarousel-<?php echo $this->get_id(); ?>">
    <div class="swiper-wrapper">
      <?php foreach ($settings['tj_video_cards'] as $item) :
        $image = $item['card_image']['url'] ?? '';
        $image_id = $item['card_image']['id'] ?? '';
        $video = $item['card_video']['url'] ?? '';
        $title = $item['card_title'] ?? '';
        $link  = $item['card_link']['url'] ?? '#';
      ?>
        <div class="swiper-slide">
          <div class="h6-hero-card">
            <div class="h6-hero-card-banner tj-el-image">
              <?php if ($image) : ?>
                <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr(get_post_meta($image_id, '_wp_attachment_image_alt', true)); ?>">
              <?php endif; ?>
              <?php if ($video) : ?>
                <a class="h6-hero-card-video video-popup" href="<?php echo esc_url($video); ?>">
                  <i class="tji-play"></i>
                </a>
              <?php endif; ?>
            </div>
            <div class="h6-hero-card-content">
              <?php if ($title) : ?>
                <h5 class="h6-hero-card-title tj-el-title">
                  <a href="<?php echo esc_url($link); ?>">
                    <?php echo esc_html($title); ?>
                  </a>
                </h5>
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <?php if ($dots === 'yes') : ?>
      <div class="swiper-pagination-area"></div>
    <?php endif; ?>
  </div>
</div>