<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Achievement.
 */
class TJ_Achievement extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-achievement';
  }

  // widget title.
  public function get_title() {
    return __('TJ Achievement', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-upgrade-crown tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'achievement',
      'award',
      'tj achievement',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // _tj_section_content
    $this->start_controls_section(
      '_tj_achievement_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'tj_achieve_no',
      [
        'label'       => esc_html__('No', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('01.', 'tjcore'),
      ]
    );
    $repeater->start_controls_tabs('achievement_tabs');
    $repeater->start_controls_tab(
      'achievement_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_normal_image',
      [
        'label'   => esc_html__('Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->end_controls_tab();
    $repeater->start_controls_tab(
      'achievement_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_hover_image',
      [
        'label'   => esc_html__('Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],

      ]
    );
    $repeater->end_controls_tab();
    $repeater->end_controls_tabs();
    $repeater->add_control(
      'tj_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Inspire<br> Growth Award', 'tjcore'),
        'row' => 3,
      ]
    );
    $repeater->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Winner', 'tjcore'),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_year',
      [
        'label'   => esc_html__('Year', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('2010', 'tjcore'),
        'label_block' => true,
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->add_control(
      'tj_achievement_list',
      [
        'label'       => esc_html__('Achievement - List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_achieve_no'        => esc_html__('01.', 'tjcore'),
            'tj_title' => tj_kses("Inspire<br> Growth Award"),
            'tj_subtitle' => esc_html__('Winner', 'tjcore'),
            'tj_year' => esc_html__('2010', 'tjcore'),
          ],
          [
            'tj_achieve_no'        => esc_html__('02.', 'tjcore'),
            'tj_title' => tj_kses("Pinnacle<br> Excellence Award"),
            'tj_subtitle' => esc_html__('Nominee', 'tjcore'),
            'tj_year' => esc_html__('2016', 'tjcore'),
          ],
          [
            'tj_achieve_no'        => esc_html__('03.', 'tjcore'),
            'tj_title' => tj_kses("Mastermind <br> Excellence Award"),
            'tj_subtitle' => esc_html__('Distinguished', 'tjcore'),
            'tj_year' => esc_html__('2020', 'tjcore'),
          ],
          [
            'tj_achieve_no'        => esc_html__('04.', 'tjcore'),
            'tj_title' => tj_kses("Game <br> Changer Award"),
            'tj_subtitle' => esc_html__('Champion', 'tjcore'),
            'tj_year' => esc_html__('2025', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_title }}}',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'tj_achievement_card_styling',
      [
        'label' => esc_html__('Item Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('tj_achievement_card_tabs');
    $this->start_controls_tab(
      'tj_achievement_card_normal',
      [
        'label' => esc_html__('Normal', 'tjcore')
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name' => 'tj_achievement_card_background',
        'label' => esc_html__('Background Color', 'tjcore'),
        'types' => ['classic', 'gradient'],
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-el-card',
      ]
    );
    $this->end_controls_tab();
    // Hover State Tab
    $this->start_controls_tab(
      'tj_achievement_card_hover',
      [
        'label' => esc_html__('Hover', 'tjcore')
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name' => 'tj_achievement_card_hover_background',
        'label' => esc_html__('Background Color', 'tjcore'),
        'types' => ['classic', 'gradient'],
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-award-wrapper .active-bg',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'tj_achievement_card_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-el-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_card_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-el-card .tj-award-item-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_card_margin',
      [
        'label' => esc_html__('Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-el-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
        ],
      ]
    );
    $this->end_controls_section();

    // no
    $this->start_controls_section(
      'tj_achievement_no_styling',
      [
        'label' => esc_html__('No - Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'tj_achievement_no_typography',
        'label' => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-award-index',
      ]
    );
    $this->start_controls_tabs('tj_achievement_no_tabs');
    // Normal State Tab
    $this->start_controls_tab('tj_achievement_no_normal', ['label' => esc_html__('Normal', 'tjcore')]);
    $this->add_control(
      'tj_achievement_no_text_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-index' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    // Hover State Tab
    $this->start_controls_tab('tj_achievement_no_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
    $this->add_control(
      'tj_achievement_no_text_hvr_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-item-inner:hover .tj-award-index' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_achievement_no_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-index' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_no_margin',
      [
        'label' => esc_html__('Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-index' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ]
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      'tj_achievement_title_styling',
      [
        'label' => esc_html__('Title - Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'tj_achievement_title_typography',
        'label' => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-award-title',
      ]
    );
    $this->start_controls_tabs('tj_achievement_title_tabs');
    // Normal State Tab
    $this->start_controls_tab('tj_achievement_title_normal', ['label' => esc_html__('Normal', 'tjcore')]);
    $this->add_control(
      'tj_achievement_title_text_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-title' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    // Hover State Tab
    $this->start_controls_tab('tj_achievement_title_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
    $this->add_control(
      'tj_achievement_title_text_hvr_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-item-inner:hover .tj-award-title' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_achievement_title_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_title_margin',
      [
        'label' => esc_html__('Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ]
      ]
    );
    $this->end_controls_section();

    // subtile
    $this->start_controls_section(
      'tj_achievement_subtile_styling',
      [
        'label' => esc_html__('Subtitle - Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'tj_achievement_subtile_typography',
        'label' => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-award-result',
      ]
    );
    $this->start_controls_tabs('tj_achievement_subtile_tabs');
    // Normal State Tab
    $this->start_controls_tab('tj_achievement_subtile_normal', ['label' => esc_html__('Normal', 'tjcore')]);
    $this->add_control(
      'tj_achievement_subtile_text_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-result' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    // Hover State Tab
    $this->start_controls_tab('tj_achievement_subtile_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
    $this->add_control(
      'tj_achievement_subtile_text_hvr_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-item-inner:hover .tj-award-result' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_achievement_subtile_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-result' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_subtile_margin',
      [
        'label' => esc_html__('Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-result' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ]
      ]
    );
    $this->end_controls_section();

    // year
    $this->start_controls_section(
      'tj_achievement_year_styling',
      [
        'label' => esc_html__('Year - Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name' => 'tj_achievement_year_typography',
        'label' => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-award-date',
      ]
    );
    $this->start_controls_tabs('tj_achievement_year_tabs');
    // Normal State Tab
    $this->start_controls_tab('tj_achievement_year_normal', ['label' => esc_html__('Normal', 'tjcore')]);
    $this->add_control(
      'tj_achievement_year_text_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-date' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    // Hover State Tab
    $this->start_controls_tab('tj_achievement_year_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
    $this->add_control(
      'tj_achievement_year_text_hvr_color',
      [
        'label' => esc_html__('Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-award-item-inner:hover .tj-award-date' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_achievement_year_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_achievement_year_margin',
      [
        'label' => esc_html__('Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
          '{{WRAPPER}} .tj-award-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ]
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/achievement/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Achievement());
