<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Socials.
 */
class TJ_Contact_Info extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-contact-info';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Contact Info', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-tel-field tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'contacts',
      'contact',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      '_tj_contact_info',
      [
        'label' => esc_html__('Contact Info', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_info_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'info_icon',
        'default'          => [
          'value'   => 'tji-envelop',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'         => esc_html__('Contact Label', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('Email us', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater = new Repeater();

    $repeater->add_control(
      'tj_info_title',
      [
        'label'         => esc_html__('Contact Info', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('Contact info', 'tjcore'),
        'row'           => 2,
      ]
    );

    $repeater->add_control(
      'tj_info_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_active',
      [
        'label' => esc_html__('Enable activation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
      ]
    );
    $this->add_control(
      'tj_contact_list',
      [
        'label' => esc_html__('Contact Info List', 'tjcore'),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_info_title' => esc_html('bexon@gmail.com'),
          ],
          [
            'tj_info_title' => esc_html('+526-8214-5622'),
          ]
        ],
        'title_field' => '{{{ tj_info_title }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------**/
    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .contact-item.style-2',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .contact-item.style-2',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      'section_social_style',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'social_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'social_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'social_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->start_controls_tabs(
      'socials_tabs'
    );

    $this->start_controls_tab(
      'style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2:hover .contact-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2:hover .contact-icon' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'icon_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'icon_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'icon_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2 .contact-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_ftitle',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .contact-item.style-2 .contact-title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2 .contact-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item.style-2 .contact-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_contact_text',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_contact_text_typography',
        'selector' => '{{WRAPPER}} .contact-item.style-2 .contact-list li a',
      ]
    );
    $this->start_controls_tabs('contact_text_style_tabs');
    $this->start_controls_tab(
      'contact_text_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_contact_text_color',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-list li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .contact-item.style-2 .contact-list li p' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'style_contact_text_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_contact_text_hcolor',
      [
        'label'     => __('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item.style-2 .contact-list li a:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_contact_list = !empty($settings['tj_contact_list']) ? $settings['tj_contact_list'] : "";

    // animation
    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $formClass = "contact-item style-2 wow $tjAnimationName";
      $this->add_render_attribute('tj-form-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $formClass = "contact-item style-2";
    }
    $this->add_render_attribute('tj-form-arg', 'class', $formClass);
?>

    <div <?php echo $this->get_render_attribute_string('tj-form-arg'); ?>>
      <?php if (!empty($settings['tj_info_icon']['value'])) : ?>
        <div class="contact-icon">
          <?php tj_render_icon($settings, 'tj_info_icon', 'info_icon'); ?>
        </div>
      <?php endif; ?>
      <?php if (!empty($settings['tj_title'])) : ?>
        <h3 class="contact-title"><?php echo esc_html($settings['tj_title']); ?></h3>
      <?php endif; ?>
      <ul class="contact-list">
        <?php foreach ($tj_contact_list as $info):
          $infoTitle = !empty($info['tj_info_title']) ? $info['tj_info_title'] : "";
          $link = !empty($info['tj_info_link']['url']) ? $info['tj_info_link']['url'] : '';
          $tj_active   = !empty($info['tj_active']) ? 'active' : '';

        ?>
          <li class="<?php echo esc_attr($tj_active); ?>">
            <?php if (!empty($infoSubtitle)) : ?>
              <?php echo esc_html($infoSubtitle); ?>
            <?php endif; ?>
            <?php if (!empty($infoTitle)): ?>
              <?php
              if (!empty($link)) :
                $href = 'href="' . esc_attr($link) . '"';
              ?>
                <a <?php echo $href; ?>>
                  <?php echo esc_html($infoTitle); ?>
                </a>
              <?php else: ?>
                <p><?php echo esc_html($infoTitle); ?></p>
              <?php endif; ?>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Contact_Info());
