<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Elementor widget for Funfact.
 */
class TJ_Counter extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-counter';
  }

  // widget title.
  public function get_title() {
    return esc_html__('TJ Counter', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-counter tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'counter',
      'counter up',
      'tj counter',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // tj counter tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Counter Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_tj_counter',
      [
        'label' => esc_html__('Counter', 'tjcore'),
      ]
    );

    // title
    $this->add_control(
      'tj_ff_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => tj_kses('Experiences'),
      ]
    );
    // number
    $this->add_control(
      'tj_ff_number',
      [
        'label'       => esc_html__('Number', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => esc_html__('13', 'tjcore'),
      ]
    );
    // prefix
    $this->add_control(
      'tj_ff_prefix',
      [
        'label'       => esc_html__('Prefix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert prefix for fact.', 'tjcore'),
      ]
    );
    // suffix
    $this->add_control(
      'tj_ff_suffix',
      [
        'label'       => esc_html__('Suffix', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'description' => esc_html__('Insert suffix for fact.', 'tjcore'),
        'default'     => tj_kses('+'),
      ]
    );
    $this->add_control(
      'tj_ff_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => tj_kses('Decades of Experience, Endless Innovation'),
        'rows'        => '3',
        'condition' => [
          'tj_design_style!' => ['2', '3', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_ff_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-complete',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'condition' => [
          'tj_design_style!' => ['1', '5', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_ff_steps',
      [
        'label' => esc_html__('Steps', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('01.', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '3', '5', '6'],
        ],
      ]
    );

    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Choose Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ['1', '2', '4', '5', '6'],
        ],
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('counter_card', 'Card- Style', '.tj-el-counter');

    // icon style
    $this->tj_icon_style_controls('counter_icon', 'Icon - Style', '.tj-el-icon', ['1', '5', '6']);

    // title style
    $this->tj_basic_style_controls('counter_title', 'Title - Style', '.tj-el-title');
    $this->tj_basic_style_controls('counter_number', 'Number - Style', '.tj-el-number');

    // description style
    $this->tj_basic_style_controls('counter_desc', 'Description - Style', '.tj-el-desc', ['3', '2', '6']);
    $this->tj_basic_style_controls('counter_steps', 'Steps Number - Style', '.tj-el-steps', ['1', '3', '5', '6']);
  }

  protected function render() {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/counter/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}

$widgets_manager->register(new TJ_Counter());
