<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Divider.
 */
class TJ_Divider extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-divider';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Divider', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-divider tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'divider',
      'partition',
      'tj divider',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // tj_content_tab
    $this->start_controls_section(
      'tj_content_tab',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_content',
      [
        'label'       => esc_html__('Content', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'rows'        => 5,
        'default'     => tj_kses('Join Over <span class="client-numbers">1000+</span> Companies with <span class="client-text">Bexon</span> Here', 'tjcore'),
        'show_label'  => false,
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );


    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'zoomOut'     => esc_html__('Zoom Out', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->tj_section_style_controls('section', 'Section - Style', '.tj-el-section');
    $this->tj_basic_style_controls('title', 'Title - Style', '.tj-el-title');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_content = $settings['tj_content'] ?? "";

    $tjAnimation       = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay  = $settings['tj_animation_delay']['size'] ?? '';

    // Initialize wrapp class
    $wrappClass = 'client-content style-2 tj-el-section';

    if (!empty($tjAnimation) && !empty($tjAnimationName)) {
      $wrappClass .= ' wow ' . esc_attr($tjAnimationName);

      if (!empty($tjAnimationDelay)) {
        $this->add_render_attribute('tj_wrapp_attr', 'data-wow-delay', esc_attr($tjAnimationDelay . 's'));
      }
    }
    $this->add_render_attribute('tj_wrapp_attr', 'class', esc_attr($wrappClass));

?>
    <div <?php echo $this->get_render_attribute_string('tj_wrapp_attr'); ?>>
      <?php if (!empty($tj_content)): ?>
        <h5 class="sec-title tj-el-title">
          <?php echo tj_kses($tj_content); ?>
        </h5>
      <?php endif; ?>
    </div>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Divider());
