<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Form.
 */
class TJ_Form extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-form';
  }

  // widget title.
  public function get_title() {
    return __('TJ Form', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-form-horizontal tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'form',
      'form',
      'tj contact',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  // Get Contact Form
  public function get_tj_contact_form() {
    if (!class_exists('WPCF7')) {
      return;
    }
    $tj_cfa     = array();
    $tj_cf_args = array('posts_per_page' => -1, 'post_type' => 'wpcf7_contact_form');
    $tj_forms   = get_posts($tj_cf_args);
    $tj_cfa     = ['0' => esc_html__('Select Form', 'tjcore')];
    if ($tj_forms) {
      foreach ($tj_forms as $tj_form) {
        $tj_cfa[$tj_form->ID] = $tj_form->post_title;
      }
    } else {
      $tj_cfa[esc_html__('No contact form found', 'tjcore')] = 0;
    }
    return $tj_cfa;
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Section Form Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_tj_form',
      [
        'label' => esc_html__('TJ Form', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_select_form',
      [
        'label'     => esc_html__('Select Form', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'separator' => 'before',
        'options'   => $this->get_tj_contact_form(),
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_form_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Get in Touch', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'is_subtitle_icon',
      [
        'label'        => esc_html__('Is subtitle icon?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_subtitle_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'show_label'       => false,
        'fa4compatibility' => 'subtitle_icon',
        'skin'             => 'inline',
        'default'          => [
          'value'   => 'tji-box',
          'library' => 'tj',
        ],
        'condition'        => [
          'is_subtitle_icon' => 'yes',
          'tj_design_style!' => ['2']
        ],
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => tj_kses('Drop Us a <span>Line.</span>', 'tjcore'),
        'rows'      => '3',
      ]
    );
    $this->add_control(
      'tj_gsap_animation',
      [
        'label'        => esc_html__('Enable GSAP Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'animation_type',
      [
        'label' => esc_html__('Animation type', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'title-anim',
        'options' => [
          'title-anim' => esc_html__('Split Text 1', 'tjcore'),
          'text-anim' => esc_html__('Split Text 2', 'tjcore'),
          'title-highlight'  => esc_html__('Title Highlight', 'tjcore'),
        ],
        'condition' => [
          'tj_gsap_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_title_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h2',
        'toggle'  => false,
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // wrapper style
    $this->tj_section_style_controls('from_wrap', 'Form Wrapper- Style', '.tj-el-form');

    // subtitle style
    $this->tj_basic_style_controls('from_subtitle', 'Sub Title - Style', '.tj-el-subtitle', ['2']);
    $this->tj_icon_style_controls('from_subtitle_icon', 'Subtitle Icon - Style', '.tj-el-subtitle', ['2']);

    // title style
    $this->tj_basic_style_controls('from_title', 'Title - Style', '.tj-el-title');

    // field style
    $this->tj_input_style_controls('from_fields', 'Form Fields - Style', '.tj-el-form');

    // Style Section: Nice Select Dropdown
    $this->start_controls_section(
      'section_style_nice_select',
      [
        'label' => esc_html__('Dropdown (Nice Select)', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    // WRAPPER STYLES
    $this->add_control(
      'nice_select_heading_wrapper',
      [
        'label' => esc_html__('Wrapper', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'nice_select_icon_color',
      [
        'label' => esc_html__('Icon Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nice-select::after' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'nice_select_wrapper_bg',
        'selector' => '{{WRAPPER}} .nice-select',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'nice_select_wrapper_border',
        'selector' => '{{WRAPPER}} .nice-select',
      ]
    );

    $this->add_responsive_control(
      'nice_select_wrapper_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .nice-select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'nice_select_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
          '{{WRAPPER}} .nice-select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // SELECTED ITEM (.current)
    $this->add_control(
      'nice_select_heading_current',
      [
        'label' => esc_html__('Selected Item (.current)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'nice_select_current_color',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nice-select .current' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'nice_select_current_typography',
        'selector' => '{{WRAPPER}} .nice-select .current',
      ]
    );

    // DROPDOWN LIST (.list)
    $this->add_control(
      'nice_select_heading_list',
      [
        'label' => esc_html__('Dropdown List (.list)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'nice_select_list_bg',
        'selector' => '{{WRAPPER}} .nice-select .list',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'nice_select_list_border',
        'selector' => '{{WRAPPER}} .nice-select .list',
      ]
    );

    // OPTIONS (.option)
    $this->add_control(
      'nice_select_heading_option',
      [
        'label' => esc_html__('Options (.option)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->start_controls_tabs('tabs_nice_select_options');

    // Normal state
    $this->start_controls_tab(
      'tab_nice_select_option_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'nice_select_option_color',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nice-select .option' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'nice_select_option_typography',
        'selector' => '{{WRAPPER}} .nice-select .option',
      ]
    );

    $this->end_controls_tab();

    // Selected/focus state
    $this->start_controls_tab(
      'tab_nice_select_option_selected',
      [
        'label' => esc_html__('Selected', 'tjcore'),
      ]
    );

    $this->add_control(
      'nice_select_option_selected_color',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .nice-select .option.selected, {{WRAPPER}} .nice-select .option.focus' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'nice_select_option_selected_bg',
        'selector' => '{{WRAPPER}} .nice-select .option.selected, {{WRAPPER}} .nice-select .option.focus',
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->end_controls_section();

    //button style
    $this->tj_button_style_controls_two('button', 'Button - Style', '.tj-el-form button', '.btn-text');
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-form button', '.btn-icon');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/form/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Form());
