<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Header.
 */
class TJ_Header extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-header';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Main Headers', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-header tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'header',
      'headers',
      'tj header',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls()
  {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Header Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Header Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
          9 => esc_html__('Style 09', 'tjcore'),
          10 => esc_html__('Style 10', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_main_header_tab
    $this->start_controls_section(
      'tj_main_header_tab',
      [
        'label' => esc_html__('Main Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    // logo
    $this->add_control(
      'tj_logo',
      [
        'label'       => esc_html__('Logo', 'tjcore'),
        'type'        => Controls_Manager::MEDIA,
        'description' => esc_html__('Upload your site logo.', 'tjcore'),
        'default'     => [
          'url' => esc_url(BEXON_ASSETS_IMAGES_URL . '/logos/primary-logo.webp'),
        ],
      ]
    );

    $this->add_control(
      'tj_sticky_logo',
      [
        'label'       => esc_html__('Sticky Logo', 'tjcore'),
        'type'        => Controls_Manager::MEDIA,
        'description' => esc_html__('Upload your site logo.', 'tjcore'),
        'default'     => [
          'url' => esc_url(BEXON_ASSETS_IMAGES_URL . '/logos/primary-logo.webp'),
        ],
      ]
    );

    // Navigation
    $menus = $this->get_available_menus();

    if (!empty($menus)) {
      $this->add_control(
        'tj_nav_menu',
        [
          'label'        => esc_html__('Select Menu', 'tjcore'),
          'type'         => \Elementor\Controls_Manager::SELECT,
          'multiple'     => false,
          'options'      => $menus,
          'default'      => '',
          'save_default' => true,
          'separator' => 'before',
        ]
      );
    } else {
      $this->add_control(
        'tj_nav_menu',
        [
          'type'            => \Elementor\Controls_Manager::RAW_HTML,
          'raw'             => sprintf(esc_html__('<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'tjcore'), admin_url('nav-menus.php?action=edit&menu=0')),
          'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
          'separator' => 'before',
        ]
      );
    }
    // search
    $this->add_control(
      'show_header_search',
      [
        'label'        => esc_html__('Show header search?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show header search?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator'    => 'before',
        'condition' => [
          'tj_design_style!' => ['4', '6'],
        ],
      ]
    );
    $this->add_control(
      'tj_search_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'search_icon',
        'default'          => [
          'value'   => 'tji-search',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'show_header_search' => "yes",
          'tj_design_style!' => ['4', '6'],
        ],
      ]
    );
    // phone
    $this->add_control(
      'show_header_phone',
      [
        'label'        => esc_html__('Show header Phone?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show header phone?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator'    => 'before',
        'condition'        => [
          'tj_design_style!' => ['1', '2', '3', '5', '7', '8', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'tj_phone_text',
      [
        'label'     => esc_html__('Phone Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('1-888-452-1505', 'tjcore'),
        'ai'        => false,
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'show_header_phone' => "yes",
          'tj_design_style!' => ['1', '2', '3', '5', '7', '8', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'tj_phone_icon',
      [
        'label'            => esc_html__('Phone Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'phone_icon',
        'default'          => [
          'value'   => 'tji-phone',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'show_header_phone' => "yes",
          'tj_design_style!' => ['1', '2', '3', '5', '7', '8', '9', '10'],
        ],
      ]
    );

    $this->add_control(
      'tj_phone_link',
      [
        'label' => esc_html__('Phone Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'show_header_phone' => "yes",
          'tj_design_style!' => ['1', '2', '3', '5', '7', '8', '9', '10'],
        ],
      ]
    );

    // sidebar
    $this->add_control(
      'show_header_sidebar',
      [
        'label'        => esc_html__('Show header sidebar?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show header sidebar?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator'    => 'before',
      ]
    );
    // button
    $this->add_control(
      'show_header_btn',
      [
        'label'        => esc_html__('Show header button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show header button?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'     => esc_html__('Button Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__("Let's Talk", 'tjcore'),
        'ai'        => false,
        'dynamic'   => [
          'active' => true,
        ],
        'condition' => [
          'show_header_btn' => "yes",
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'show_header_btn' => "yes",
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'condition' => [
          'show_header_btn' => "yes",
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'show_header_btn'  => "yes",
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'show_header_btn'  => "yes",
          'tj_btn_link_type' => '2',
        ],
      ]
    );

    // header absolute
    $this->add_control(
      'is_header_absolute',
      [
        'label'        => esc_html__('Is Transparent Header?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show transparent header?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
        'condition'   => [
          'tj_design_style' => ['2', '3', '5', '6', '7', '8', '9', '10']
        ],
      ]
    );
    // header sticky
    $this->add_control(
      'is_header_sticky',
      [
        'label'        => esc_html__('Is Sticky Header?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show sticky header?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'header_sticky_direction',
      [
        'label'     => esc_html__('Sticky Direction', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          'sticky-up' => esc_html__('Scroll Up', 'tjcore'),
          'sticky-down' => esc_html__('Scroll Down', 'tjcore'),
        ],
        'default'   => 'sticky-up',
        'condition'   => [
          'is_header_sticky'  => "yes",
        ],
      ]
    );
    $this->end_controls_section();

    // tj_hamburger_tab
    $this->start_controls_section(
      'tj_hamburger_tab',
      [
        'label' => esc_html__('Hamburger Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    // mobile logo
    $this->add_control(
      'tj_mobile_logo',
      [
        'label'       => esc_html__('Mobile logo', 'tjcore'),
        'type'        => Controls_Manager::MEDIA,
        'description' => esc_html__('Upload your site logo.', 'tjcore'),
        'default'     => [
          'url' => esc_url(BEXON_ASSETS_IMAGES_URL . '/logos/secondary-logo.webp'),
        ],
      ]
    );
    // close icon
    $this->add_control(
      'tj_mobile_close',
      [
        'label'            => esc_html__('Close Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'mobile_close',
        'default'          => [
          'value'   => 'lnr-cross',
          'library' => 'ln',
        ],
      ]
    );
    $this->add_control(
      'tj_mobile_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('we are committed to delivering innovative solutions that drive growth and add value to our clients. With a team of experienced professionals and a passion for excellence.', 'tjcore'),
        'label_block' => true,
        'row'         => '3'
      ]
    );
    // mobile search
    $this->add_control(
      'show_mobile_search',
      [
        'label'        => esc_html__('Show mobile search?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show mobile search?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_mobile_search_title',
      [
        'label'       => esc_html__('Search Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Search Now!', 'tjcore'),
        'label_block' => true,
        'condition'        => [
          'show_mobile_search' => "yes",
        ],
      ]
    );
    // Search icon
    $this->add_control(
      'tj_mobile_search_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'mobile_search_icon',
        'default'          => [
          'value'   => 'fa-light fa-search',
          'library' => 'fa-light',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'show_mobile_search' => "yes",
        ],
      ]
    );
    // search placeholder
    $this->add_control(
      'tj_mobile_search_placeholder',
      [
        'label'   => esc_html__('placeholder', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__("Search here..", 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition'        => [
          'show_mobile_search' => "yes",
        ],
      ]
    );
    // mobile contact info
    $this->add_control(
      'is_mobile_contact',
      [
        'label'        => esc_html__('Is mobile contact?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show contact information?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'mobile_contact_title',
      [
        'label'       => esc_html__('Contact Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Contact Info', 'tjcore'),
        'label_block' => true,
        'condition'   => [
          'is_mobile_contact' => "yes",
        ],
      ]
    );
    $mobileContact = new Repeater();
    $mobileContact->add_control(
      'mobile_contact_label',
      [
        'label'       => esc_html__('Label', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Text us', 'tjcore'),
        'label_block' => true,
      ]
    );
    $mobileContact->add_control(
      'mobile_contact_text',
      [
        'label'       => esc_html__('Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('info@bexon.com', 'tjcore'),
        'label_block' => true,
      ]
    );
    $mobileContact->add_control(
      'mobile_contact_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'mobile_contact_list',
      [
        'label'     => esc_html__('Contact List', 'tjcore'),
        'type'      => Controls_Manager::REPEATER,
        'fields'    => $mobileContact->get_controls(),
        'default'   => [
          [
            'mobile_contact_text'    => esc_html('(+012) 3456 7890'),
          ],
          [
            'mobile_contact_text'    => esc_html('info@bexon.com'),
          ],
          [
            'mobile_contact_text'    => esc_html('993 Renner Burg, West Rond, MT 94251-030, Russia'),
          ],
        ],
        'condition' => [
          'is_mobile_contact' => "yes",
        ],
      ]
    );

    // mobile Socials
    $this->add_control(
      'is_mobile_socials',
      [
        'label'        => esc_html__('Is mobile socials?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'description'  => esc_html__('Do you want to show mobile socials?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'mobile_socials_title',
      [
        'label'       => esc_html__('Social Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Follow Us', 'tjcore'),
        'label_block' => true,
        'condition'   => [
          'is_mobile_socials' => "yes",
        ],
      ]
    );
    $mobileSocials = new Repeater();
    $mobileSocials->add_control(
      'tj_mobile_social_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'mobile_social_icon',
      ]
    );
    $mobileSocials->add_control(
      'mobile_social_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'mobile_socials_list',
      [
        'label'       => esc_html__('Socials List', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $mobileSocials->get_controls(),
        'default'     => [
          [
            'tj_mobile_social_icon' => [
              'value'   => 'fab fa-facebook-f',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_mobile_social_icon' => [
              'value'   => 'fab fa-instagram',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_mobile_social_icon' => [
              'value'   => 'fab fa-x-twitter',
              'library' => 'fa-brands',
            ],
          ],
          [
            'tj_mobile_social_icon' => [
              'value'   => 'fab fa-linkedin-in',
              'library' => 'fa-brands',
            ],
          ],
        ],
        'title_field' => '{{{ elementor.helpers.renderIcon( this, tj_mobile_social_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',
        'condition'   => [
          'is_mobile_socials' => "yes",
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // main header
    $this->start_controls_section(
      'main_header_style',
      [
        'label' => esc_html__('Main Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('style_tabs');
    $this->start_controls_tab(
      'header_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'header_normal_background',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .header-area, {{WRAPPER}} .header-2.header-absolute .header-wrapper, {{WRAPPER}} .h10-header.header-area.header-absolute .mainmenu > ul ',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'header_normal_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .header-area, {{WRAPPER}} .header-2.header-absolute .header-wrapper',
      ]
    );
    $this->add_responsive_control(
      'header_normal_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .header-2.header-absolute .header-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'header_normal_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'header_sticky_tab',
      [
        'label' => esc_html__('Sticky', 'tjcore'),
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'header_sticky_background',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .header-area.header-duplicate',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'header_sticky_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .header-area.header-duplicate',
      ]
    );
    $this->add_responsive_control(
      'header_sticky_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-area.header-duplicate' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'header_sticky_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-area.header-duplicate' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'header_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .header-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // logo style
    $this->start_controls_section(
      '_header_logo_style',
      [
        'label' => esc_html__('Logo', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_logo_width',
      [
        'label'      => esc_html__('Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 500,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .site_logo .logo' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_logo_max_width',
      [
        'label'      => esc_html__('Max Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 500,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .site_logo .logo' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_logo_height',
      [
        'label'      => esc_html__('Height', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 500,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .site_logo .logo img' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Navigation style
    $this->start_controls_section(
      '_header_nav_style',
      [
        'label' => esc_html__('Nav Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'nav_menu_typography',
        'selector' => '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li > a',
      ]
    );
    $this->start_controls_tabs('nav_style_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'nav_normal_solid_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li > a'        => 'color: {{VALUE}} ',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li > a::after' => 'color: {{VALUE}} ',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'nav_hover_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li:hover > a'        => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li:hover > a::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'nav_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'nav_active_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.active > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.current-menu-item > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.current-menu-ancestor > a'         => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.active > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.current-menu-item > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li.current-menu-ancestor > a::after'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'nav_vertical_padding',
      [
        'label'      => esc_html__('Vertical Padding', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li > a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => "before",
      ]
    );
    $this->add_responsive_control(
      'nav_space_between',
      [
        'label'      => esc_html__('Space Between', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu)' => 'column-gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Navigation style
    $this->start_controls_section(
      '_header_sticky_nav_style',
      [
        'label' => esc_html__('Sticky Nav Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs('sticky_nav_style_tabs');
    $this->start_controls_tab(
      'sticky_nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'sticky_nav_normal_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li > a'        => 'color: {{VALUE}} ',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li > a::after' => 'color: {{VALUE}} ',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'sticky_nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'sticky_nav_hover_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li:hover > a'        => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li:hover > a::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'sticky_nav_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'sticky_nav_active_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.active > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.current-menu-item > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.current-menu-ancestor > a'         => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.active > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.current-menu-item > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-area.header-duplicate .mainmenu ul:not(.sub-menu) > li.current-menu-ancestor > a::after'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // dropdown
    $this->start_controls_section(
      '_header_dropdown_style',
      [
        'label' => esc_html__('Dropdown', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'important_note',
      [
        'label'           => esc_html__('Important Note', 'tjcore'),
        'type'            => Controls_Manager::RAW_HTML,
        'raw'             => esc_html__('On desktop, this will affect the submenu.', 'tjcore'),
        'content_classes' => 'elementor-descriptor',
        'show_label'      => false,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'submenu_background',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image', 'video'],
        'selector' => '{{WRAPPER}} .mainmenu ul > li > .sub-menu',
      ]
    );
    $this->add_responsive_control(
      'submenu_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'submenu_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .mainmenu ul > li > .sub-menu',
      ]
    );
    $this->add_responsive_control(
      'submenu_distance',
      [
        'label'      => esc_html__('Distance', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['%', 'px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => '%',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul:not(.sub-menu) > li:hover > .sub-menu' => 'top: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'      => 'submenu_typography',
        'selector'  => '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li > a',
        'separator' => 'before',
      ]
    );
    $this->start_controls_tabs('submenu_style_tabs');
    $this->start_controls_tab(
      'submenu_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'submenu_normal_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li > a'        => 'color: {{VALUE}} ',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li > a::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'submenu_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'submenu_hover_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li:hover > a'        => 'color: {{VALUE}} ',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li:hover > a::after' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'submenu_style_active_tab',
      [
        'label' => esc_html__('Active', 'tjcore'),
      ]
    );
    $this->add_control(
      'submenu_active_solid_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.active > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.current-menu-item > a'             => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.current-menu-ancestor > a'         => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.active > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.current-menu-item > a::after'      => 'color: {{VALUE}}',
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li.current-menu-ancestor > a::after'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'submenu_horizontal_padding',
      [
        'label'      => esc_html__('Horizontal Padding', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li > a' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => "before",
      ]
    );
    $this->add_responsive_control(
      'submenu_vertical_padding',
      [
        'label'      => esc_html__('Vertical Padding', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .mainmenu ul > li > .sub-menu > li > a' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->tj_button_style_controls_two('button', 'Button - Style', '.tj-primary-btn', '.btn-text');
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-primary-btn', '.btn-icon');

    // header search
    $this->start_controls_section(
      'section_header_contact_style',
      [
        'label' => esc_html__('Header Phone', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_header_phone' => "yes",
          'tj_design_style!' => ['1', '2', '3', '5', '7', '8', '9', '10'],
        ],
      ]
    );

    $this->start_controls_tabs('tabs_header_contact_style');

    // NORMAL TAB
    $this->start_controls_tab(
      'tab_header_contact_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    // Text Color
    $this->add_control(
      'phone_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact .call-text' => 'color: {{VALUE}};',
        ],
      ]
    );

    // Icon Color
    $this->add_control(
      'phone_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact .call-icon' => 'color: {{VALUE}};',
        ],
      ]
    );

    // Background
    $this->add_control(
      'phone_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    // HOVER TAB
    $this->start_controls_tab(
      'tab_header_contact_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );

    $this->add_control(
      'phone_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact:hover .call-text' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'phone_icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact:hover .call-icon' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'phone_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-contact:hover' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    // ACTIVE TAB
    $this->start_controls_tab(
      'tab_header_contact_active',
      [
        'label' => esc_html__('Sticky', 'tjcore'),
      ]
    );

    $this->add_control(
      'phone_text_active_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .header-contact .call-text' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'phone_icon_active_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .header-contact .call-icon' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'phone_bg_active_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .header-contact' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'phone_text_typography',
        'selector' => '{{WRAPPER}} .header-contact .call-text',
      ]
    );

    // Padding
    $this->add_responsive_control(
      'phone_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .header-contact' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Border Radius
    $this->add_responsive_control(
      'phone_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .header-contact' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // header search
    $this->start_controls_section(
      '_header_search_style',
      [
        'label'     => __('Header Search', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_header_search' => 'yes',
          'tj_design_style!' => ['4', '6'],
        ],
      ]
    );
    $this->add_control(
      'header_search_01',
      [
        'label' => esc_html__('Search Button', 'tjcore'),
        'type'  => Controls_Manager::HEADING,
      ]
    );
    $this->add_responsive_control(
      'search_btn_size',
      [
        'label'      => esc_html__('Icon Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .header-search .search' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('style_search_tabs');
    $this->start_controls_tab(
      'search_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'search_btn_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-search .search i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-search .search' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'search_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'search_btn_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-search .search:hover i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-search .search:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'sticky_search_btn_hover_tab',
      [
        'label' => esc_html__('Sticky', 'tjcore'),
      ]
    );
    $this->add_control(
      'sticky_search_btn_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .header-search .search i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .header-duplicate .header-search .search' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'header_search_02',
      [
        'label'     => esc_html__('Search Area', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'search_bg_color',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .search_popup',
      ]
    );

    $this->add_control(
      'header_search_03',
      [
        'label'     => esc_html__('Search Field', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'search_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .search_form input[type=text]',
      ]
    );
    $this->add_control(
      'search_field_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .search_form input[type=text]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'search_field_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .search_form input[type=text]::placeholder'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .search_form input[type=text]::-moz-placeholder'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .search_form input[type=text]::-ms-input-placeholder'     => 'color: {{VALUE}}',
          '{{WRAPPER}} .search_form input[type=text]::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'search_field_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .search_form input[type=text]' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'search_field_btn_size',
      [
        'label'      => esc_html__('Field Button Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .search_form button[type=submit]' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->start_controls_tabs('style_search_field_btn_tabs');
    $this->start_controls_tab(
      'search_field_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'search_field_btn_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .search_form button[type=submit]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'search_field_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'search_field_btn_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .search_form button[type=submit]:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // Hamburger
    $this->start_controls_section(
      '_hamburger_style',
      [
        'label' => esc_html__('Hamburger', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'header_hamburger_01',
      [
        'label'     => esc_html__('Toggle Button', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
      ]
    );
    $this->start_controls_tabs('hamburger_btn_tabs');
    $this->start_controls_tab(
      'hamburger_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_btn_normal_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu_bar span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hamburger_btn_normal_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu_bar' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'hamburger_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_btn_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu_bar:hover span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'hamburger_btn_hover_bgcolor',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu_bar:hover' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'sticky_hamburger_btn_normal_tab',
      [
        'label' => esc_html__('Sticky', 'tjcore'),
      ]
    );
    $this->add_control(
      'sticky_hamburger_btn_normal_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .menu_bar span' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'sticky_hamburger_btn_bg_color',
      [
        'label'     => esc_html__('Backgournd Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .header-duplicate .menu_bar' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_control(
      'header_hamburger_02',
      [
        'label'     => esc_html__('Hamburger Area', 'tjcore'),
        'type'      => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'hamburger_bg_color',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'exclude'  => ['image'],
        'selector' => '{{WRAPPER}} .hamburger_bg, {{WRAPPER}} .hamburger_wrapper::before',
      ]
    );
    $this->add_responsive_control(
      'hamburger_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_logo_max_width',
      [
        'label'      => esc_html__('Logo Width', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 500,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .mobile_logo' => 'max-width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'hamburger_close_btn_size',
      [
        'label'      => esc_html__('Close Icon Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .hamburger_close_btn' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->start_controls_tabs('style_hamburger_close_tabs');
    $this->start_controls_tab(
      'hamburger_close_icon_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_close_icon_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_close_btn i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'hamburger_close_icon_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_close_icon_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_close_btn:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    $this->tj_basic_style_controls('desc', 'Offcanvas Text - Style', '.offcanvas-text p');

    // sidebar / hamburger search
    $this->start_controls_section(
      '_sidebar_hamburger_search_style',
      [
        'label' => esc_html__('Sidebar / Hamburger Search', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'side_mobile_field_typo',
        'label'    => esc_html__('Field Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .hamburger_search input[type=search]',
      ]
    );
    $this->add_control(
      'side_mobile_field_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search input[type=search]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_mobile_field_placeholder_color',
      [
        'label'     => esc_html__('Placeholder Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search input[type=search]::placeholder'               => 'color: {{VALUE}}',
          '{{WRAPPER}} .hamburger_search input[type=search]::-moz-placeholder'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .hamburger_search input[type=search]::-ms-input-placeholder'     => 'color: {{VALUE}}',
          '{{WRAPPER}} .hamburger_search input[type=search]::-webkit-input-placeholder' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_mobile_field_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search input[type=search]' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_mobile_field_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search input[type=search]' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_mobile_field_border_radius',
      [
        'label' => esc_html__('Border Radius', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .hamburger_search form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_mobile_field_btn_size',
      [
        'label'      => esc_html__('Field Button Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', 'rem', 'custom'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 1000,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => '',
        ],
        'selectors'  => [
          '{{WRAPPER}} .hamburger_search button[type=submit]' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->start_controls_tabs('style_side_mobile_field_btn_tabs');
    $this->start_controls_tab(
      'side_mobile_field_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_mobile_field_btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search button[type=submit]' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_mobile_field_btn_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search button[type=submit]' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'side_mobile_field_btn_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_mobile_field_btn_hover_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search button[type=submit]:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_mobile_field_btn_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger_search button[type=submit]:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'side_mobile_search_margin',
      [
        'label' => esc_html__('Search Margin', 'tjcore'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors' => [
          '{{WRAPPER}} .hamburger_search' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Hamburger menu
    $this->start_controls_section(
      '_hamburger_menu_style',
      [
        'label' => esc_html__('Hamburger Menu', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'hamburger_menu_typography',
        'selector' => '{{WRAPPER}} .mean-nav ul li > a:not(.mean-expand)',
      ]
    );
    $this->start_controls_tabs('hamburger_menu_style_tabs');
    $this->start_controls_tab(
      'hamburger_menu_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_menu_normal_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mean-nav ul li > a'            => 'color: {{VALUE}}',
          '{{WRAPPER}} .mean-nav ul li > .mean-expand' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'hamburger_menu_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'hamburger_menu_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mean-nav ul li:hover > a'            => 'color: {{VALUE}}',
          '{{WRAPPER}} .mean-nav ul li:hover > .mean-expand' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_control(
      'hamburger_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .mean-nav ul li a' => 'border-bottom-color: {{VALUE}}',
          '{{WRAPPER}} .mean-nav ul li.mean-last a' => 'border-bottom-color: {{VALUE}}',
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'hamburger_menu_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .mean-nav ul li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // sidebar / hamburger Contact
    $this->start_controls_section(
      '_sidebar_hamburger_contact_style',
      [
        'label' => esc_html__('Hamburger Contact', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'side_ham_contact_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-infos' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ham_side_contact_title_options',
      [
        'label' => esc_html__('Contact Title', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before'
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'side_hamburger_contact_title_typography',
        'selector' => '{{WRAPPER}} .hamburger-title',
      ]
    );
    $this->add_control(
      'side_hamburger_contact_title_color',
      [
        'label'     => esc_html__('Title Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_hamburger_contact_title_padding',
      [
        'label'      => esc_html__('Title Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-title'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_hamburger_contact_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-title'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ham_side_contact_options',
      [
        'label' => esc_html__('Contact Item', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'side_ham_contact_item_icon_size',
      [
        'label' => esc_html__('Label Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .contact-item .subtitle' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'side_ham_contact_item_icon_color',
      [
        'label'     => esc_html__('Label Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item .subtitle' => 'color: {{VALUE}} ',
        ],
        'separator' => 'after'
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'side_ham_contact_item_typography',
        'selector' => '{{WRAPPER}} .contact-item .text a',
      ]
    );
    $this->start_controls_tabs('contact_item_style_tabs');
    $this->start_controls_tab(
      'side_ham_contact_item_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_ham_contact_item_normal_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item .contact-link' => 'color: {{VALUE}} ',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'side_ham_contact_item_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_ham_contact_item_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .contact-item .contact-link:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'side_ham_contact_item_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'side_ham_contact_item_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .contact-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // sidebar / hamburger Socials
    $this->start_controls_section(
      '_sidebar_hamburger_socials_style',
      [
        'label' => esc_html__('Sidebar / Hamburger Socials', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'ham_side_socials_title_options',
      [
        'label' => esc_html__('Socials Title', 'tjcore'),
        'type' => Controls_Manager::HEADING,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'side_hamburger_socials_title_typography',
        'selector' => '{{WRAPPER}} .hamburger-socials .hamburger-title',
      ]
    );
    $this->add_control(
      'side_hamburger_socials_title_color',
      [
        'label'     => esc_html__('Title Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials .hamburger-title' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->add_responsive_control(
      'side_hamburger_socials_title_padding',
      [
        'label'      => esc_html__('Title Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-socials .hamburger-title'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_hamburger_socials_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-socials .hamburger-title'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'ham_side_socials_icon_options',
      [
        'label' => esc_html__('Socials Icon', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'side_ham_social_width',
      [
        'label' => esc_html__('Width', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a' => 'width: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_ham_social_height',
      [
        'label' => esc_html__('Height', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_ham_social_gap',
      [
        'label' => esc_html__('Gap', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => "",
        ],
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul' => 'gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'side_ham_social_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->start_controls_tabs('side_ham_social_tabs');
    $this->start_controls_tab(
      'side_ham_social_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_ham_social_icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_ham_social_icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'side_ham_social_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'side_ham_social_icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'side_ham_social_icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .hamburger-socials ul li a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'side_ham_social_icon_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .hamburger-socials ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();
  }


  /**
   * Get WordPress menus.
   */
  private function get_available_menus()
  {
    $menus = wp_get_nav_menus();
    $options = [];
    foreach ($menus as $menu) {
      $options[$menu->slug] = $menu->name;
    }
    return $options;
  }

  /**
   * Render navigation menu with or without ID.
   */
  private function render_tj_nav_menu($menu_slug, $add_menu_id = true)
  {
    $walker = class_exists('\TJCore\TJ_Navwalker_Class')
      ? new \TJCore\TJ_Navwalker_Class()
      : '';

    $args = [
      'echo'        => false,
      'menu'        => $menu_slug,
      'menu_class'  => 'menu',
      'menu_id'     => $add_menu_id ? 'main-header-menu' : false,
      'container'   => '',
      'fallback_cb' => '__return_empty_string',
      'walker'      => $walker,
    ];

    return wp_nav_menu($args);
  }



  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/headers/style-' . $tj_design_style . '.php';
?>

<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Header());
