<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Icon Box.
 */
class TJ_Icon_Box extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-icon-box';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Icon Box', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-icon-box tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'icon-box',
      'icon-box',
      'tj icon-box',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Icon box Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_icon_box_content
    $this->start_controls_section(
      '_tj_icon_box_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_iconbox_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'tji-innovative',
          'library' => 'tj',
        ],
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );
    $this->add_control(
      'tj_iconbox_number',
      [
        'label'       => esc_html__('Number', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('01', 'tjcore'),
        'label_block' => false,
        'condition' => [
          'tj_design_style!' => ['1', '3', '4', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'tj_iconbox_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Innovative Solutions', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_iconbox_link',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
      ]
    );
    $this->add_control(
      'tj_iconbox_desc',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'default' => esc_html__('We stay ahead of the curve, leveraging cutting-edge technologies and strategies to keep you competitive in a marketplace.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_iconbox_btn',
      [
        'label'       => esc_html__('Button', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Read more', 'tjcore'),
        'condition'   => [
          'tj_design_style!' => ['1', '2', '4', '6']
        ],
      ]
    );
    $this->add_control(
      'tj_iconbox_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => false,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'condition'   => [
          'tj_design_style!' => ['1', '2', '4', '6']
        ],
      ]
    );

    $this->add_responsive_control(
      'text_alignment',
      [
        'label'     => esc_html__('Alignment', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'start'    => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center'  => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'end'   => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'   => '',
        'selectors' => [
          '{{WRAPPER}} .tj-el-box .choose-content' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
          '{{WRAPPER}} .service-details-item' => 'text-align: {{VALUE}};',
        ],
        'condition'   => [
          'tj_design_style!' => ['6']
        ],
      ]
    );

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    // card style
    $this->tj_card_style_controls('icon_card', 'Card- Style', '.tj-el-box');

    // icon style
    $this->tj_icon_style_controls_two('icon', 'Icon - Style', '.tj-el-box', '.tj-el-icon', ['2']);

    // number style
    $this->tj_basic_style_controls_two('number', 'Number - Style', '.tj-el-box', '.tj-el-number', ['1', '3', '4', '5', '6']);

    // title style
    $this->tj_basic_style_controls_two('title', 'Title - Style', '.tj-el-box', '.tj-el-title');

    // description style
    $this->tj_basic_style_controls_two('desc', 'Description - Style', '.tj-el-box', '.tj-el-desc');

    $this->tj_link_style_controls('button', 'Button - Style', '.tj-el-box', '.tj-el-btn .btn-text', ['1', '2', '4', '6']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-box', '.tj-el-btn .btn-icon', ['1', '2', '4', '6']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/icon-box/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Icon_Box());
