<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Latest Posts.
 */
class TJ_Latest_Posts extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-latest-posts';
  }

  // widget title.
  public function get_title() {
    return __('TJ Latest Posts', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-post-list tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'latest-post',
      'posts',
      'tj post',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Post Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Post Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
          8 => esc_html__('Style 08', 'tjcore'),
          9 => esc_html__('Style 09', 'tjcore'),
          10 => esc_html__('Style 10', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Post Query
    $this->start_controls_section(
      'tj_post_query',
      [
        'label' => esc_html__('Post Query', 'tjcore'),
      ]
    );

    $post_type = 'post';
    $taxonomy  = 'category';

    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Posts Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '3',
      ]
    );
    $this->add_control(
      'category',
      [
        'label'       => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label'       => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Posts', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );
    $this->add_control(
      'ignore_sticky_posts',
      [
        'label'        => esc_html__('Ignore Sticky Posts', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Count', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );
    $this->add_control(
      'tj_post_content',
      [
        'label'        => __('Content', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition'   => [
          'tj_design_style!'  => ['4', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'tj_post_content_limit',
      [
        'label'       => __('Content Limit', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => '18',
        'dynamic'     => [
          'active' => true,
        ],
        'condition'   => [
          'tj_post_content'  => 'yes',
          'tj_design_style!'  => ['4', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'tj_btn',
      [
        'label'   => esc_html__('Button Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Read more', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Button Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'label_block' => false,
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
      ]
    );
    $this->end_controls_section();

    // post meta
    $this->start_controls_section(
      'tj_post_meta_tab',
      [
        'label' => esc_html__('Post Meta', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_post_author',
      [
        'label'        => esc_html__('Post Author', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'condition' => [
          'tj_design_style!' => ['7']
        ]
      ]
    );
    $this->add_control(
      'tj_post_date',
      [
        'label'        => esc_html__('Post Date', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_post_category',
      [
        'label'        => esc_html__('Post Category', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->end_controls_section();

    // Animation
    $this->start_controls_section(
      '_section_animation_content',
      [
        'label' => esc_html__('Animation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'fadeInUp',
        'options'   => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.2,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    // Column Settings
    $this->start_controls_section(
      'section_column_settings',
      [
        'label' => esc_html__('Column Settings', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
        'condition'  => [
          'tj_design_style!' => ['2', '4', '5', '8', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'desktop_column',
      [
        'label' => esc_html__('Desktop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 1200px', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '4',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'laptop_column',
      [
        'label' => esc_html__('Laptop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 992px', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'tablet_column',
      [
        'label' => esc_html__('Tablet', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 768px', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'mobile_column',
      [
        'label' => esc_html__('Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 768px', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'ex_mobile_column',
      [
        'label' => esc_html__('Small Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 576px', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1 Columns', 'tjcore'),
          6 => esc_html__('2 Columns', 'tjcore'),
          4 => esc_html__('3 Columns', 'tjcore'),
          3 => esc_html__('4 Columns', 'tjcore'),
          2 => esc_html__('6 Columns', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );
    $this->end_controls_section();


    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition'  => [
          'tj_design_style!' => ['1', '3', '4', '5', '6', '7', '8', '9', '10'],
        ],
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_nav',
      [
        'label'        => esc_html__('Is Nav?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // wrapper style
    $this->tj_section_style_controls('blog_item', 'Wrapper - Style', '.blog-item');
    $this->tj_card_style_controls('blog_inner', 'Wrapper Inner - Style', '.blog-item .blog-content');

    // title style
    $this->tj_basic_style_controls('blog_title', 'Title - Style', '.blog-item .title');

    // content style
    $this->tj_basic_style_controls('blog_desc', 'Content - Style', '.blog-item .desc', ['4', '9', '10']);

    // button style
    $this->tj_link_style_controls('button', 'Button - Style', '.text-btn', '.btn-text');
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.text-btn', '.btn-icon');

    // category style
    $this->tj_basic_style_controls('blog_cat', 'Category - Style', '.blog-meta .categories a');

    // author style
    $this->tj_basic_style_controls('blog_author', 'Author - Style', '.blog-meta span a', ['7']);

    // date style for 7
    $this->tj_basic_style_controls('blog_date', 'Date - Style', '.blog-date p', ['1', '2', '3', '4', '5', '6', '8']);

    // date style
    $this->start_controls_section(
      'section_style_blog_date',
      [
        'label' => esc_html__('Date Style', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['7', '9', '10']
        ]
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'blog_date_background',
        'selector' => '{{WRAPPER}} .blog-date',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'blog_date_border',
        'selector' => '{{WRAPPER}} .blog-date',
      ]
    );
    $this->add_responsive_control(
      'blog_date_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .blog-date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'blog_date_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
          '{{WRAPPER}} .blog-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    //
    // Date (.date)
    //
    $this->add_control(
      'blog_date_heading_date',
      [
        'label' => esc_html__('Date Number (.date)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'blog_date_color_date',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-date .date' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'blog_date_typography_date',
        'selector' => '{{WRAPPER}} .blog-date .date',
      ]
    );
    //
    // Month (.month)
    //
    $this->add_control(
      'blog_date_heading_month',
      [
        'label' => esc_html__('Month Text (.month)', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'blog_date_color_month',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .blog-date .month' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'blog_date_typography_month',
        'selector' => '{{WRAPPER}} .blog-date .month',
      ]
    );
    $this->end_controls_section();


    // dots style
    $this->tj_swiper_dot_style_controls('swiper_dots', 'Dots - Style', '.swiper-pagination-area', ['1', '3', '4', '5', '6', '7', '8', '9', '10']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/latest-posts/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Latest_Posts());
