<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Tj List.
 */
class TJ_Megamenu_Widgets extends Widget_Base
{

    // widget name
    public function get_name()
    {
        return 'tj-mega-menu';
    }

    // widget title
    public function get_title()
    {
        return esc_html__('TJ Mega Menu', 'tjcore');
    }

    // widget icon
    public function get_icon()
    {
        return 'eicon-editor-list-ul tj-icon';
    }

    // Widget categories.
    public function get_categories()
    {
        return ['tjcore'];
    }

    // scripts dependencies.
    public function get_script_depends()
    {
        return ['tjcore-script'];
    }

    // styles dependencies.
    public function get_style_depends()
    {
        return ['tjcore-style'];
    }

    // Widget keywords.
    public function get_keywords()
    {
        return [
            'menu',
            'menus',
            'tj menu',
            'tj megamenu',
            'tj addons',
            'tjcore',
        ];
    }

    // Widget help url.
    public function get_custom_help_url()
    {
        return 'https://go.elementor.com/';
    }

    /**
     * widget controls.
     */
    protected function register_controls()
    {
        // tj feature tab
        $this->start_controls_section(
            'tj_design_tab',
            [
                'label' => esc_html__('Menu Style', 'tjcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'tj_design_style',
            [
                'label'   => esc_html__('Select Menu Style', 'tjcore'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    1 => esc_html__('Style 01', 'tjcore'),
                    2 => esc_html__('Style 02', 'tjcore'),
                    3 => esc_html__('Style 03', 'tjcore'),
                ],
                'default' => 1,
            ]
        );
        $this->end_controls_section();

        // lists
        $this->start_controls_section(
            'section_mega_menu',
            [
                'label'         => esc_html__('Mega Menu', 'tjcore'),
            ]
        );

        $this->add_control(
            'tj_menu_title',
            [
                'label'       => esc_html__('Page Title', 'tjcore'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Page Title', 'tjcore'),
                'label_block' => true,
                'condition' => [
                    "tj_design_style" => ['3']
                ]
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'field_condition',
            [
                'label' => __('Field condition', 'tjcore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => __('Style 01', 'tjcore'),
                    2 => __('Style 02', 'tjcore'),
                    3 => __('Style 03', 'tjcore'),
                ],
                'default' => '1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );
        $repeater->add_control(
            'tj_demo_image',
            [
                'label'   => esc_html__('Image', 'tjcore'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'field_condition!' => ['2', '3'],
                ],
            ]
        );
        $repeater->add_control(
            'tj_menu_icon',
            [
                'label'         => esc_html__('Icon', 'tjcore'),
                'type'          => Controls_Manager::ICONS,
                'fa4compatibility' => 'menu_icon',
                'default'          => [
                    'value' => 'tji-arrow-right-long',
                    'library' => 'tj',
                ],
                'condition' => [
                    'field_condition!' => ['3'],
                ],
            ]
        );
        $repeater->add_control(
            'tj_menu_btn',
            [
                'label'         => esc_html__('Button', 'tjcore'),
                'type'          => Controls_Manager::TEXT,
                'default'       => esc_html__('View demo', 'tjcore'),
                'label_block' => true,
                'condition' => [
                    'field_condition!' => ['3'],
                ],

            ]
        );
        $repeater->add_control(
            'tj_menu_item',
            [
                'label'         => esc_html__('Title', 'tjcore'),
                'type'          => Controls_Manager::TEXT,
                'default'       => esc_html__('Menu Item', 'tjcore'),
                'label_block' => true
            ]
        );

        $repeater->add_control(
            'tj_menu_link_type',
            [
                'label'     => esc_html__('Link Type', 'tjcore'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    '1' => esc_html__('Custom Link', 'tjcore'),
                    '2' => esc_html__('Internal Page', 'tjcore'),
                ],
                'default'   => '1',
            ]
        );
        $repeater->add_control(
            'tj_menu_link',
            [
                'label'       => esc_html__('link', 'tjcore'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
                'default'     => [
                    'url'               => '#',
                    'is_external'       => false,
                    'nofollow'          => false,
                    'custom_attributes' => '',
                ],
                'condition'   => [
                    'tj_menu_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'tj_menu_page_link',
            [
                'label'       => esc_html__('Select Page', 'tjcore'),
                'type'        => Controls_Manager::SELECT2,
                'label_block' => true,
                'options'     => tj_get_all_pages(),
                'condition'   => [
                    'tj_menu_link_type' => '2',
                ],
            ]
        );

        $repeater->add_control(
            'tj_badge',
            [
                'label'        => esc_html__('Enable Badge?', 'tjcore'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Yes', 'tjcore'),
                'label_off'    => esc_html__('No', 'tjcore'),
                'return_value' => 'yes',
                'default'      => '',
                'separator'    => 'before',
                'condition' => [
                    'field_condition!' => ['2'],
                ],
            ]
        );
        $repeater->add_control(
            'tj_menu_badge',
            [
                'label'         => esc_html__('Badge', 'tjcore'),
                'type'          => Controls_Manager::TEXT,
                'default'       => esc_html__('New', 'tjcore'),
                'label_block' => false,
                'condition' => [
                    'field_condition!' => ['2'],
                    'tj_badge' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'tj_menu_list',
            [
                'label'         => esc_html__('Menu Items', 'tjcore'),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $repeater->get_controls(),
                'default'       => [
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 01'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 02'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 03'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 04'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 05'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 06'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 07'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 08'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 09'),
                    ],
                    [
                        'tj_menu_item'       => tj_kses('Homepage - 10'),
                    ],
                ],
                'title_field' => '{{{ tj_menu_item }}}',
            ]
        );

        $this->end_controls_section();
        /** ---------------------------------------------------------------
         * TAB_STYLE
         * -------------------------------------------------------------* */
        $this->start_controls_section(
            'style_menu_card',
            [
                'label' => esc_html__('Card Style', 'tjcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tj_design_style!' => ['2', '3'],
                ]
            ]
        );

        $this->add_control(
            'tj_menu_card_color',
            [
                'label'     => __('Backgroud Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-demo-thumb' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tj_menu_card_overlay',
            [
                'label'     => __('Overlay Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-demo-thumb .image::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_menu_card_border',
                'selector' => '{{WRAPPER}} .tj-demo-thumb',
            ]
        );
        $this->add_responsive_control(
            'tj_menu_card_padding',
            [
                'label'      => esc_html__('Padding', 'tjcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .tj-demo-thumb' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // title
        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__('Title', 'tjcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tj_design_style' => ['3'],
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tj_title_typography',
                'selector' => '{{WRAPPER}} .mega-menu-title',
            ]
        );
        $this->add_control(
            'tj_title_color',
            [
                'label'     => __('Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tj_title_line_color',
            [
                'label'     => __('Line Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-title::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_title_padding',
            [
                'label'      => esc_html__('Padding', 'tjcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .mega-menu-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_title_margin',
            [
                'label'      => esc_html__('Margin', 'tjcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .mega-menu-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Menu 
        $this->start_controls_section(
            '_style_stitle',
            [
                'label' => esc_html__('Menu Title', 'tjcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tj_stitle_typography',
                'selector' => '{{WRAPPER}} .tj-demo-thumb .tj-demo-title, {{WRAPPER}} .mega-menu-list a, {{WRAPPER}} .mega-menu-service a',
            ]
        );
        $this->start_controls_tabs('stitle_style_tabs');
        $this->start_controls_tab(
            'stitle_normal_tab',
            [
                'label' => esc_html__('Normal', 'tjcore'),
            ]
        );
        $this->add_control(
            'tj_stitle_color',
            [
                'label'     => __('Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-demo-thumb .tj-demo-title a, {{WRAPPER}} .mega-menu-list a, {{WRAPPER}} .mega-menu-service a, {{WRAPPER}} .mega-menu-service-single .mega-menu-service-nav' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_stitle_hover_tab',
            [
                'label' => esc_html__('Hover', 'tjcore'),
            ]
        );
        $this->add_control(
            'tj_stitle_hcolor',
            [
                'label'     => __('Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-demo-thumb .tj-demo-title a:hover, {{WRAPPER}} .mega-menu-list a:hover, {{WRAPPER}} .mega-menu-service a:hover, {{WRAPPER}} .mega-menu-service-single .mega-menu-service-nav:hover' => 'color: {{VALUE}} !important',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_stitle_border',
                'selector' => '{{WRAPPER}} .mega-menu-service a',
                'condition' => [
                    'tj_design_style' => ['2'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tj_stitle_padding',
            [
                'label'      => esc_html__('Padding', 'tjcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .tj-demo-thumb .tj-demo-title, {{WRAPPER}} .mega-menu-list a, {{WRAPPER}} .mega-menu-service a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_stitle_margin',
            [
                'label'      => esc_html__('Margin', 'tjcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors'  => [
                    '{{WRAPPER}} .tj-demo-thumb .tj-demo-title, {{WRAPPER}} .mega-menu-list a, {{WRAPPER}} .mega-menu-service a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // icon
        $this->start_controls_section(
            'section_style_ficon',
            [
                'label' => esc_html__('Icon style', 'tjcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tj_design_style' => ['2'],
                ]
            ]
        );

        $this->add_responsive_control(
            'ficon_font_size',
            [
                'label' => esc_html__('Icon Size', 'tjcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-service-single .mega-menu-service-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs('icon_style_tabs');
        $this->start_controls_tab(
            'icon_normal_tab',
            [
                'label' => esc_html__('Normal', 'tjcore'),
            ]
        );
        $this->add_control(
            'tj_icon_color',
            [
                'label'     => __('Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-service-single .mega-menu-service-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tj_icon_bgcolor',
            [
                'label'     => __('Background Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-service-single .mega-menu-service-icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_icon_hover_tab',
            [
                'label' => esc_html__('Hover', 'tjcore'),
            ]
        );
        $this->add_control(
            'tj_icon_hcolor',
            [
                'label'     => __('Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-service-single:hover .mega-menu-service-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tj_icon_bg_hcolor',
            [
                'label'     => __('Background Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega-menu-service-single:hover .mega-menu-service-icon' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        //Button
        $this->start_controls_section(
            '_heading_hero_btn_style',
            [
                'label' => __('Button', 'tjcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'tj_design_style!' => ['2', '3'],
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typography',
                'selector' => '{{WRAPPER}} .tj-primary-btn .btn-text',
            ]
        );
        $this->start_controls_tabs('btn_style_tabs');
        $this->start_controls_tab(
            'btn_normal_tab',
            [
                'label' => esc_html__('Normal', 'tjcore'),
            ]
        );
        $this->add_control(
            'btn_text_color',
            [
                'label'     => esc_html__('Text Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tj-primary-btn .btn-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn .btn-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_bgcolor',
            [
                'label'     => esc_html__('Icon Bg Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn .btn-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label'     => esc_html__('Background Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__('Hover', 'tjcore'),
            ]
        );
        $this->add_control(
            'btn_text_hcolor',
            [
                'label'     => esc_html__('Text Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tj-primary-btn:hover .btn-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_hcolor',
            [
                'label'     => esc_html__('Icon Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn:hover .btn-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_hbgcolor',
            [
                'label'     => esc_html__('Icon Bg Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn:hover .btn-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_hcolor',
            [
                'label'     => esc_html__('Background Color', 'tjcore'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tj-primary-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

        include dirname(__FILE__) . '/styles/mega-menu/style-' . $tj_design_style . '.php';
    }

    protected function content_template() {}
}
$widgets_manager->register(new TJ_Megamenu_Widgets());
