<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Portfolio Navigation.
 */
class Tj_Navigation extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-navigation';
  }

  // widget title
  public function get_title()
  {
    return esc_html__('TJ Navigation', 'tjcore');
  }

  // widget icon
  public function get_icon()
  {
    return 'eicon-post-navigation tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'navigation',
      'tj navigation',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      '_section_content',
      [
        'label' => esc_html__('Navigation Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'previous_nav_label',
      [
        'label' => esc_html__('Previous Navigation', 'tjcore'),
        'type'  => Controls_Manager::TEXT,
        'default' => esc_html__('Previous', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'next_nav_label',
      [
        'label' => esc_html__('Next Navigation', 'tjcore'),
        'type'  => Controls_Manager::TEXT,
        'default' => esc_html__('Next', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->start_controls_section(
      'section_style_fcontent',
      [
        'label' => esc_html__('Wrapper style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_wrapper_background',
        'exclude' => ['image', 'video'],
        'selector' => '{{WRAPPER}} .tj-post-navigation',
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'wrapper_border',
        'selector' => '{{WRAPPER}} .tj-post-navigation',
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-post-navigation' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-post-navigation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_wrapper_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-post-navigation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
        ],
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'section_nav_style',
      [
        'label' => esc_html__('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'nav_typography',
        'selector' => '{{WRAPPER}} .prev_post a, {{WRAPPER}} .next_post a',
      ]
    );
    $this->add_control(
      'nav_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .prev_post a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .next_post a' => 'color: {{VALUE}}',
        ],
      ]
    );

    $this->start_controls_tabs('navs_tabs');
    $this->start_controls_tab(
      'nav_style_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .prev_post a i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .next_post a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .prev_post a' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .next_post a' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'nav_style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .prev_post a i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .next_post a i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'icon_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .prev_post a:hover' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .next_post a:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    // middle icon
    $this->start_controls_section(
      'section_middle_icon_style',
      [
        'label' => esc_html__('Middle Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'icon_icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 100,
            'step' => 1,
          ],
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .menu-bar a' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->start_controls_tabs('icon_icon_tabs');
    $this->start_controls_tab(
      'icon_icon_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'middle_icon_normal_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu-bar a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'icon_icon_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'middle_icon_hover_color',
      [
        'label'     => esc_html__('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .menu-bar a:hover i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();
  }

  protected function render()
  {
    $settings        = $this->get_settings_for_display();

    $prevLabel = !empty($settings['previous_nav_label']) ? $settings['previous_nav_label'] : "";
    $nextLabel = !empty($settings['next_nav_label']) ? $settings['next_nav_label'] : "";

?>
    <?php if (get_previous_post_link() || get_next_post_link()) : ?>
      <div class="tj-post-navigation mb-0 wow fadeInUp" data-wow-delay="0.3s">
        <!-- previous post -->
        <div class="previous">
          <?php
          $prevPost = get_adjacent_post(false, '', true);
          if (is_a($prevPost, 'WP_Post')) :
            $prevLink = get_permalink($prevPost->ID);
          ?>
            <div class="tj-post-nav prev_post">
              <a href="<?php echo esc_url($prevLink); ?>">
                <span><i class="tji-arrow-left"></i></span>
                <?php if (!empty($prevLabel)) : ?>
                  <?php echo esc_html__($prevLabel, 'tjcore'); ?>
                <?php endif; ?>
              </a>
            </div>
          <?php endif; ?>
        </div>
        <!-- menu -->
        <div class="tj-post-nav-divider menu-bar">
          <a href="<?php echo esc_url(get_post_type_archive_link(get_post_type(get_the_ID()))); ?>">
            <i class="tji-window"></i>
          </a>
        </div>
        <!-- next post -->
        <div class="next">
          <?php
          $nextPost = get_adjacent_post(false, '', false);
          if (is_a($nextPost, 'WP_Post')) :
            $nextLink = get_permalink($nextPost->ID);
          ?>
            <div class="tj-post-nav next_post">
              <a href="<?php echo esc_url($nextLink); ?>">
                <?php if (!empty($nextLabel)) : ?>
                  <?php echo esc_html__($nextLabel, 'tjcore'); ?>
                <?php endif; ?>
                <span><i class="tji-arrow-right"></i></span>
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>

    <?php endif; ?>
<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new Tj_Navigation());
