<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Pricing Box.
 */
class TJ_Pricing_Box extends Widget_Base
{

  // widget name
  public function get_name()
  {
    return 'tj-pricing-box';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Pricing Box', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-price-table tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'pricing',
      'pricing table',
      'tj price',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Box Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Header
    $this->start_controls_section(
      '_section_header',
      [
        'label' => __('Box Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'price_title',
      [
        'label'       => __('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => esc_html__('Premium', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'price_description',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 3,
        'default' => esc_html__('Save 20% offer of consulting 93K clients.', 'tjcore'),
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );

    $this->add_control(
      'is_price_box_recommend',
      [
        'label'        => __('Is this recommended?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'price_badge',
      [
        'label'       => __('Badge', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => tj_kses('<i class="tji-star-2"></i> <span>Popular</span>', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
        'condition' => [
          'is_price_box_recommend' => 'yes',
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_pricing',
      [
        'label' => __('Pricing', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_price_currency',
      [
        'label'       => __('Currency', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'label_block' => false,
        'options'     => [
          ''             => __('None', 'tjcore'),
          'baht'         => '&#3647; ' . _x('Baht', 'Currency Symbol', 'tjcore'),
          'bdt'          => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'tjcore'),
          'dollar'       => '&#36; ' . _x('Dollar', 'Currency Symbol', 'tjcore'),
          'euro'         => '&#128; ' . _x('Euro', 'Currency Symbol', 'tjcore'),
          'franc'        => '&#8355; ' . _x('Franc', 'Currency Symbol', 'tjcore'),
          'guilder'      => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'tjcore'),
          'krona'        => 'kr ' . _x('Krona', 'Currency Symbol', 'tjcore'),
          'lira'         => '&#8356; ' . _x('Lira', 'Currency Symbol', 'tjcore'),
          'peseta'       => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'tjcore'),
          'peso'         => '&#8369; ' . _x('Peso', 'Currency Symbol', 'tjcore'),
          'pound'        => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'tjcore'),
          'real'         => 'R$ ' . _x('Real', 'Currency Symbol', 'tjcore'),
          'ruble'        => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'tjcore'),
          'rupee'        => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'tjcore'),
          'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'tjcore'),
          'shekel'       => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'tjcore'),
          'won'          => '&#8361; ' . _x('Won', 'Currency Symbol', 'tjcore'),
          'yen'          => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'tjcore'),
          'custom'       => __('Custom', 'tjcore'),
        ],
        'default'     => 'dollar',
      ]
    );
    $this->add_control(
      'tj_currency_custom',
      [
        'label'     => __('Custom Symbol', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'condition' => [
          'price_currency' => 'custom',
        ],
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );

    $this->start_controls_tabs('pricing_price_tabs');
    $this->start_controls_tab(
      'pricing_month_tab',
      [
        'label' => esc_html__('Monthly', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_monthly_price',
      [
        'label'   => __('Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('99', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_month_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/per month', 'tjcore'),
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'pricing_year_tab',
      [
        'label' => esc_html__('Yearly', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_yearly_price',
      [
        'label'   => __('Yearly Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('999', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_year_price_period',
      [
        'label'   => __('Period', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('/per year', 'tjcore'),
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_features',
      [
        'label' => __('Features', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_feature_title',
      [
        'label'   => __('Feature Title', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Plan Include:', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->add_control(
      'tj_feature_desc',
      [
        'label'   => __('Feature Desc', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('Includes all Standard plan and Plus:', 'tjcore'),
        'rows' => 3,
        'condition' => [
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'tj_feature_available',
      [
        'label'        => __('Feature Hide ?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $repeater->add_control(
      'tj_feature_icon',
      [
        'show_label'  => true,
        'type'        => Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => "feature_icon",
        'default'     => [
          'value'   => 'tji-list',
          'library' => 'tj',
        ],
      ]
    );
    $repeater->add_control(
      'tj_feature_text',
      [
        'label'   => esc_html__('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => esc_html__('Inculde your feature', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_feature_list',
      [
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'show_label'  => false,
        'default'     => [
          [
            'tj_feature_text' => esc_html__('All features in Basic Plan'),
          ],
          [
            'tj_feature_text' => esc_html__('Priority customer support'),
          ],
          [
            'tj_feature_text' => esc_html__('Up to 3 projects per month'),
          ],
          [
            'tj_feature_text' => esc_html__('Monthly performance reviews'),
          ],
          [
            'tj_feature_text' => esc_html__('Collaboration tools for team'),
          ],
          [
            'tj_feature_text' => esc_html__('Priority support'),
          ],
          [
            'tj_feature_text' => esc_html__('4/7 emergency service'),
          ],
        ],
        'title_field' => '{{{ tj_feature_text }}}',
      ]
    );
    $this->end_controls_section();

    // tj_btn_button_group
    $this->start_controls_section(
      'tj_btn_button_group',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Choose package', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'fa4compatibility' => 'btn_icon',
        'skin' => 'inline',
        'label_block' => false
      ]
    );
    $this->end_controls_section();

    // animation
    $this->start_controls_section(
      'tj_animation_group',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',

      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */


    $this->start_controls_section(
      'section_style_pricing_box',
      [
        'label' => esc_html__('Pricing Box', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'pricing_box_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'selectors'  => [
          '{{WRAPPER}} .pricing-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'pricing_box_padding',
      [
        'label' => esc_html__('Padding', 'tjcore'),
        'type' => \Elementor\Controls_Manager::DIMENSIONS,
        'selectors' => [
          '{{WRAPPER}} .pricing-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    // Box Background
    $this->start_controls_tabs('tabs_pricing_box_style');

    $this->start_controls_tab('tab_pricing_box_normal', ['label' => esc_html__('Normal', 'tjcore')]);

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'pricing_box_bg',
        'selector' => '{{WRAPPER}} .pricing-box',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'pricing_box_border',
        'selector' => '{{WRAPPER}} .pricing-box',
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab('tab_pricing_box_active', ['label' => esc_html__('Active', 'tjcore')]);

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'pricing_box_active_bg',
        'selector' => '{{WRAPPER}} .pricing-box.active',
      ]
    );

    $this->add_control(
      'pricing_box_active_border_color',
      [
        'label' => esc_html__('Border Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .pricing-box.active' => 'border-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->end_controls_section();


    $this->start_controls_section('section_style_pricing_title', [
      'label' => esc_html__('Title & Description', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);
    $this->add_control('pricing_bg_color', [
      'label' => esc_html__('Background Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .h10-pricing-box .pricing-header' => 'background-color: {{VALUE}};',
      ],
      'condition' => [
        'tj_design_style!' => ['1', '2']
      ]
    ]);

    $this->start_controls_tabs('tabs_pricing_title');
    $this->start_controls_tab('tab_pricing_title_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);
    $this->add_control('pricing_title_color', [
      'label' => esc_html__('Title Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-name' => 'color: {{VALUE}};',
      ],
    ]);
    $this->add_control('pricing_desc_color', [
      'label' => esc_html__('Description Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-desc' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    $this->start_controls_tab('tab_pricing_title_active', [
      'label' => esc_html__('Active', 'tjcore'),
    ]);

    $this->add_control('pricing_title_active_color', [
      'label' => esc_html__('Title Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box.active .package-name' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_desc_active_color', [
      'label' => esc_html__('Description Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box.active .package-desc' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Typography Controls (Shared for both states)
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'pricing_title_typography',
        'label'    => esc_html__('Title Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-name',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'pricing_desc_typography',
        'label'    => esc_html__('Description Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-desc',
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section('section_style_price', [
      'label' => esc_html__('Price', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);

    // Start Tabs: Normal & Active
    $this->start_controls_tabs('tabs_price_parts_style');

    // --- Normal Tab ---
    $this->start_controls_tab('tab_price_parts_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);

    $this->add_control('price_currency_color', [
      'label' => esc_html__('Currency Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-currency' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('price_number_color', [
      'label' => esc_html__('Price Number Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .price-number' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('price_period_color', [
      'label' => esc_html__('Period Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box .package-period' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    // --- Active Tab ---
    $this->start_controls_tab('tab_price_parts_active', [
      'label' => esc_html__('Active', 'tjcore'),
    ]);

    $this->add_control('price_currency_active_color', [
      'label' => esc_html__('Currency Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box.active .package-currency' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('price_number_active_color', [
      'label' => esc_html__('Price Number Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box.active .price-number' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('price_period_active_color', [
      'label' => esc_html__('Period Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-box.active .package-period' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    $this->end_controls_tabs();

    // Typography (Shared)
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_number_typography',
        'label'    => esc_html__('Price Number Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .price-number',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_currency_typography',
        'label'    => esc_html__('Currency Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-currency',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'price_period_typography',
        'label'    => esc_html__('Period Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .pricing-box .package-period',
      ]
    );

    $this->end_controls_section();

    // price button
    $this->start_controls_section('section_style_pricing_button', [
      'label' => esc_html__('Pricing Button', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);

    $this->start_controls_tabs('tabs_pricing_button_style');

    // === Normal Tab ===
    $this->start_controls_tab('tab_pricing_button_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);

    $this->add_control('pricing_btn_text_color', [
      'label' => esc_html__('Text Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-text' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_bg_color', [
      'label' => esc_html__('Background Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'background-color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_icon_color', [
      'label' => esc_html__('Icon Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-icon i' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_icon_bg_color', [
      'label' => esc_html__('Icon Background Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn .btn-icon' => 'background-color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    // === Hover Tab ===
    $this->start_controls_tab('tab_pricing_button_hover', [
      'label' => esc_html__('Hover', 'tjcore'),
    ]);

    $this->add_control('pricing_btn_hover_text_color', [
      'label' => esc_html__('Text Color (Hover)', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover .btn-text' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn .btn-text' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_hover_bg_color', [
      'label' => esc_html__('Background Color (Hover)', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover' => 'background-color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn' => 'background-color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_icon_hover_color', [
      'label' => esc_html__('Icon Color (Hover)', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover .btn-icon i' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn .btn-icon i' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('pricing_btn_border_hover_color', [
      'label' => esc_html__('Border Color', 'tjcore'),
      'type' => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn:hover' => 'color: {{VALUE}};',
        '{{WRAPPER}} .pricing-box.active .pricing-btn .text-btn' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Border
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name' => 'pricing_btn_border',
        'selector' => '{{WRAPPER}} .pricing-btn .text-btn',
      ]
    );

    // Border Radius
    $this->add_responsive_control('pricing_btn_radius', [
      'label' => esc_html__('Border Radius', 'tjcore'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', '%', 'em'],
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);

    // Padding
    $this->add_responsive_control('pricing_btn_padding', [
      'label' => esc_html__('Padding', 'tjcore'),
      'type' => \Elementor\Controls_Manager::DIMENSIONS,
      'size_units' => ['px', '%', 'em'],
      'selectors' => [
        '{{WRAPPER}} .pricing-btn .text-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
      ],
    ]);

    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'pricing_btn_typography',
        'selector' => '{{WRAPPER}} .pricing-btn .text-btn .btn-text',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section('section_style_feature_list', [
      'label' => esc_html__('Feature List', 'tjcore'),
      'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
    ]);
    // Typography
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'feature_list_typography',
        'selector' => '{{WRAPPER}} .list-items ul li',
      ]
    );

    $this->start_controls_tabs('tabs_feature_list_style');
    // === Normal Tab ===
    $this->start_controls_tab('tab_feature_list_normal', [
      'label' => esc_html__('Normal', 'tjcore'),
    ]);

    $this->add_control('feature_list_text_color', [
      'label' => esc_html__('Text Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('feature_list_icon_color', [
      'label' => esc_html__('Icon Color', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'color: {{VALUE}};',
      ],
    ]);

    $this->end_controls_tab();

    // === Active Tab ===
    $this->start_controls_tab('tab_feature_list_active', [
      'label' => esc_html__('Active', 'tjcore'),
    ]);

    $this->add_control('feature_list_text_active_color', [
      'label' => esc_html__('Text Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li.active' => 'color: {{VALUE}};',
      ],
    ]);

    $this->add_control('feature_list_icon_active_color', [
      'label' => esc_html__('Icon Color (Active)', 'tjcore'),
      'type'  => \Elementor\Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items ul li.active i' => 'color: {{VALUE}};',
      ],
    ]);
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Icon Size
    $this->add_control('feature_list_icon_size', [
      'label' => esc_html__('Icon Size', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 10, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
      ],
      'separator' => 'before'
    ]);

    // Icon Spacing
    $this->add_control('feature_list_icon_spacing', [
      'label' => esc_html__('Icon Spacing', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 0, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li i' => 'margin-right: {{SIZE}}{{UNIT}};',
      ],
    ]);
    // Item Gap
    $this->add_control('feature_list_item_gap', [
      'label' => esc_html__('Item Spacing', 'tjcore'),
      'type' => \Elementor\Controls_Manager::SLIDER,
      'range' => [
        'px' => ['min' => 0, 'max' => 50],
      ],
      'selectors' => [
        '{{WRAPPER}} .list-items ul li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
      ],
    ]);

    $this->add_control(
      'pricing_feature_title_option',
      [
        'label' => esc_html__('Feature Title', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    // Typography
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'feature_title_typography',
        'selector' => '{{WRAPPER}} .list-items .h5-pricing-list-title, {{WRAPPER}} .list-items .title-wrapper .title',
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->add_control('feature_title_color', [
      'label' => esc_html__('Title Color', 'tjcore'),
      'type'  => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items .h5-pricing-list-title' => 'color: {{VALUE}};',
        '{{WRAPPER}} .list-items .title-wrapper .title' => 'color: {{VALUE}};',
      ],
      'condition' => [
        'tj_design_style!' => ['1']
      ]
    ]);
    $this->add_control(
      'pricing_feature_desc_option',
      [
        'label' => esc_html__('Feature Desc', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
        'condition' => [
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );
    // Typography
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'feature_desc_typography',
        'selector' => '{{WRAPPER}} .list-items .title-wrapper .desc',
        'condition' => [
          'tj_design_style!' => ['1', '2']
        ]
      ]
    );
    $this->add_control('feature_desc_color', [
      'label' => esc_html__('Desc Color', 'tjcore'),
      'type'  => Controls_Manager::COLOR,
      'selectors' => [
        '{{WRAPPER}} .list-items .title-wrapper .desc' => 'color: {{VALUE}};',
      ],
      'condition' => [
        'tj_design_style!' => ['1', '2']
      ]
    ]);
    $this->end_controls_section();
  }

  private static function get_currency_symbol($symbol_name)
  {
    $symbols = [
      'baht'         => '&#3647;',
      'bdt'          => '&#2547;',
      'dollar'       => '&#36;',
      'euro'         => '&#128;',
      'franc'        => '&#8355;',
      'guilder'      => '&fnof;',
      'indian_rupee' => '&#8377;',
      'pound'        => '&#163;',
      'peso'         => '&#8369;',
      'peseta'       => '&#8359',
      'lira'         => '&#8356;',
      'ruble'        => '&#8381;',
      'shekel'       => '&#8362;',
      'rupee'        => '&#8360;',
      'real'         => 'R$',
      'krona'        => 'kr',
      'won'          => '&#8361;',
      'yen'          => '&#165;',
    ];

    return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/pricing-box/style-' . $tj_design_style . '.php';
  }
}

$widgets_manager->register(new TJ_Pricing_Box());
