<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Working process.
 */
class TJ_Process extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;


  // widget name
  public function get_name()
  {
    return 'tj-process';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Process', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-chevron-double-right tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'process',
      'tj process',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Process Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_section_content
    $this->start_controls_section(
      '_tj_process_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );

    // repeater 
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );
    $repeater->add_control(
      'tj_process_icon',
      [
        'label' => __('Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'process_icon',
        'default' => [
          'value' => 'tji-service-1',
          'library' => 'tj',
        ],
        'condition'   => [
          'field_condition!' => ['1'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_process_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'tj_process_text',
      [
        'label' => esc_html__('Description', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'rows' => 6,
        'placeholder' => esc_html__('Type your description here', 'tjcore'),
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'bounceInUp'  => esc_html__('Bounce In Up', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );

    $this->add_control(
      'tj_process_list',
      [
        'label'       => esc_html__('Working Process', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_process_icon' => [
              'value' => 'tji-human',
              'library' => 'tj',
            ],
            'tj_process_title' => esc_html__('Discovery & Planning', 'tjcore'),
            'tj_process_text' => esc_html__('The first step in our process is understanding your unique business needs, objectives, and our cutomes challenges.', 'tjcore')
          ],
          [
            'tj_process_icon' => [
              'value' => 'tji-human',
              'library' => 'tj',
            ],
            'tj_process_title' => esc_html__('Execution & Delivery', 'tjcore'),
            'tj_process_text' => esc_html__('Once the plan is in place, our team moves forward with execution, turning strategies into actiony to deliver', 'tjcore')
          ],
          [
            'tj_process_icon' => [
              'value' => 'tji-human',
              'library' => 'tj',
            ],
            'tj_process_title' => esc_html__('Review & Support', 'tjcore'),
            'tj_process_text' => esc_html__('After project completion, we conduct a thorough review to ensure everything aligns with your goals and requirements', 'tjcore')
          ],
        ],
        'title_field' => '{{{ tj_process_title }}}',
      ]
    );

    $this->add_control(
      'tj_number_show',
      [
        'label'        => esc_html__('Hide Steps Number?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'separator'    => 'before',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    $this->tj_card_style_controls('process_card', 'Card- Style', '.tj-el-process');

    // number style
    $this->tj_basic_style_controls('process_number', 'Number - Style', '.tj-el-number');

    // title style
    $this->tj_basic_style_controls('process_title', 'Title - Style', '.tj-el-title');

    // description style
    $this->tj_basic_style_controls('process_desc', 'Description - Style', '.tj-el-desc');

    // icon style
    $this->tj_icon_style_controls('process_icon', 'Icon - Style', '.tj-el-icon', ['1', '2', '3']);

    $this->start_controls_section(
      'step_indicator_style_section',
      [
        'label' => esc_html__('Step Indicator', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['1', '3', '4'],
        ]
      ]
    );

    $this->start_controls_tabs('step_indicator_tabs');

    // Normal
    $this->start_controls_tab(
      'step_indicator_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'step_indicator_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-indicator' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'step_indicator_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-indicator' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'step_indicator_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-indicator' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .h5-working-process-inner::after' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-el-indicator::before' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-el-indicator::after' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    // Hover
    $this->start_controls_tab(
      'step_indicator_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'step_indicator_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-indicator:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'step_indicator_bg_hover_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-indicator:hover' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'step_indicator_hover_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:hover .tj-el-indicator' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-el-process:hover .tj-el-indicator::before' => 'border-color: {{VALUE}}',
          '{{WRAPPER}} .tj-el-process:hover .tj-el-indicator::after' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // Typography / Spacing
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'step_indicator_typography',
        'selector' => '{{WRAPPER}} .tj-el-indicator',
      ]
    );
    $this->add_responsive_control(
      'step_indicator_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-indicator' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();


    $this->start_controls_section(
      'section_style_tj_icon',
      [
        'label' => esc_html__('Icon Style', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => ['2', '3'],
        ]
      ]
    );

    $this->add_control(
      'icon_size',
      [
        'label' => esc_html__('Icon Size', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::SLIDER,
        'range' => [
          'px' => [
            'min' => 10,
            'max' => 100,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:not(:last-child)::after' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Background::get_type(),
      [
        'name'     => 'icon_box_background',
        'selector' => '{{WRAPPER}} .tj-el-process:not(:last-child)::after',
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'icon_box_border',
        'selector' => '{{WRAPPER}} .tj-el-process:not(:last-child)::after',
      ]
    );

    $this->add_responsive_control(
      'icon_box_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .tj-el-process:not(:last-child)::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    //
    // Icon Styling (.tj-el-icon i)
    //
    $this->start_controls_tabs('tabs_icon_style');

    $this->start_controls_tab(
      'tab_icon_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );

    $this->add_control(
      'icon_color',
      [
        'label' => esc_html__('Icon Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:not(:last-child)::after' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'icon_bg_color',
      [
        'label' => esc_html__('Background Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:not(:last-child)::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'tab_icon_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );

    $this->add_control(
      'icon_hover_color',
      [
        'label' => esc_html__('Icon Hover Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:not(:last-child):hover::after' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'icon_hover_bg',
      [
        'label' => esc_html__('Background Hover Color', 'tjcore'),
        'type'  => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-el-process:not(:last-child):hover::after' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/process/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Process());
