<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Process.
 */
class TJ_Progress_Bar extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-progress-bar';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Progress', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-skill-bar tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'progress',
      'skill-bar',
      'tj progress',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {
    // tj feature tab
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Progress Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Progress Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_icon_box_content
    $this->start_controls_section(
      '_tj_icon_box_content',
      [
        'label' => esc_html__('Progress Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('Business Progress', 'tjcore'),
        'label_block' => true,
        'condition'        => [
          'tj_design_style!' => ['3', '4'],
        ],
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'tj_progress_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Progress Title', 'tjcore'),
        'label_block' => 'true',
      ]
    );
    $repeater->add_control(
      'tj_progress',
      [
        'label' => esc_html__('Progress', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['%'],
        'range' => [
          '%' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default' => [
          'unit' => '%',
          'size' => 90,
        ],
      ]
    );

    $this->add_control(
      'tj_progress_list',
      [
        'label'       => esc_html__('Progress Item', 'tjcore'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'tj_progress_title' => esc_html__('Business consultants', 'tjcore'),
          ],
          [
            'tj_progress_title' => esc_html__('Client communication', 'tjcore'),
          ]
        ],
        'title_field' => '{{{ tj_progress_title }}}',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Progress Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_section_style_controls('progress_wrapper', 'Outer Wrapper - Style', '.box-area', ['3']);
    $this->tj_section_style_controls('progress_innerwrap', 'Inner Wrapper - Style', '.progress-box', ['3']);

    // title style
    $this->tj_basic_style_controls('progress_heading', 'Heading - Style', '.progress-box .title', ['3']);
    $this->tj_basic_style_controls('progress_title', 'Progress Title - Style', '.tj-progress-title', ['4']);
    $this->tj_basic_style_controls('progress_percent', 'Progress Percent - Style', '.tj-progress-percent', ['4']);

    // Circle progress
    $this->tj_basic_style_controls('circle_title', 'Progress Title - Style', '.progress-text .sub-title', ['1', '2', '3']);
    $this->tj_basic_style_controls('circle_percent', 'Progress Percent - Style', '.progress-circle input', ['1', '2', '3']);

    $this->start_controls_section(
      'tj_skillbar_style_sec',
      [
        'label' => esc_html__('Progress Bar Style', 'tjcore'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'tj_skillbar_color',
      [
        'label'       => esc_html__('Bar Color', 'tjcore'),
        'type'     => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-progress-bar' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->add_control(
      'tj_skillbar_bg_color',
      [
        'label'       => esc_html__('Bar Base Color', 'tjcore'),
        'type'     => \Elementor\Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-progress' => 'background: {{VALUE}}',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/progress-bar/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Progress_Bar());
