<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Repeater;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for About.
 */
class TJ_Project_Info extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-project-info';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Project Info', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-lightbox tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'project',
      'tj project info',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Information Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // project info tab
    $this->start_controls_section(
      'tj_project_info_tab',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_section_title',
      [
        'label' => esc_html__('Section Title', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Project Info', 'tjcore'),
        'placeholder' => esc_html__('Type your title here', 'tjcore'),
        'label_block' => true
      ]
    );

    // repeater
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );

    $repeater->add_control(
      'tj_item_icon',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'item_icon',
        'skin'             => 'inline',
        'label_block'      => true,
        'default'          => [
          'value' => 'tji-user',
          'library' => 'tj',
        ],
        'condition' => [
          'field_condition!' => ['2'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_project_info_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('Type subtitle here.', 'tjcore'),
        'show_label' => true,
        'label_block' => true,
        'dynamic'       => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_info_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type' => Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Type title here.', 'tjcore'),
        'rows' => 2,
        'dynamic'       => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'project_info_list',
      [
        'show_label' => false,
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_project_info_subtitle' => esc_html__('Clients', 'tjcore'),
            'tj_project_info_title' => esc_html__('Innovate Interiors Group', 'tjcore'),
          ],
          [
            'tj_project_info_subtitle' => esc_html__('Budget', 'tjcore'),
            'tj_project_info_title' => esc_html__('$100M USD', 'tjcore'),
          ],
          [
            'tj_project_info_subtitle' => esc_html__('Location', 'tjcore'),
            'tj_project_info_title' => esc_html__('Maplewood Heights, CA', 'tjcore'),
          ],
          [
            'tj_project_info_subtitle' => esc_html__('Sector', 'tjcore'),
            'tj_project_info_title' => esc_html__('Corporate Business', 'tjcore'),
          ],
          [
            'tj_project_info_subtitle' => esc_html__('Complete date', 'tjcore'),
            'tj_project_info_title' => esc_html__('Jul 20, 2025', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_project_info_title }}}',
      ]
    );

    // animation    
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    // animation name
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    // animation delay
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'separator' => 'after',
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();
    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // Wrapper style
    $this->tj_section_style_controls('pinfo_card', 'Wrapper - Style', '.tj-sidebar-widget');

    // widget title style
    $this->tj_basic_style_controls('pinfo_widget_title', 'Heading - Style', '.tj-sidebar-widget .widget-title');

    // Label style
    $this->tj_basic_style_controls('list_label', 'Label - Style', '.tj-sidebar-widget .project-text span');

    // title style
    $this->tj_basic_style_controls('list_title', 'Title - Style', '.tj-sidebar-widget .project-text .title');

    // icon style
    $this->tj_icon_style_controls('list_icon', 'Icon - Style', '.tj-sidebar-widget .project-icons');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/project-info/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Project_Info());
