<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for project list.
 */
class TJ_Project_list extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-project-list';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Project List', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-posts-grid tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'project',
      'projects',
      'tj project',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Project Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );

    $this->end_controls_section();

    // tj_section_title
    $this->start_controls_section(
      'tj_section_title',
      [
        'label' => esc_html__('Section Title', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '3', '4'],
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Section Subtitle', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'is_subtitle_icon',
      [
        'label'        => esc_html__('Is subtitle icon?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'tj_subtitle_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'show_label'       => false,
        'fa4compatibility' => 'subtitle_icon',
        'default'          => [
          'value'   => 'tji-box',
          'library' => 'tj',
        ],
        'condition'        => [
          'is_subtitle_icon' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('Section Title', 'tjcore'),
        'rows'      => '3',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_gsap_animation',
      [
        'label'        => esc_html__('Enable GSAP Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'animation_type',
      [
        'label' => esc_html__('Animation type', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'title-anim',
        'options' => [
          'title-anim' => esc_html__('Split Text 1', 'tjcore'),
          'text-anim' => esc_html__('Split Text 2', 'tjcore'),
          'title-highlight'  => esc_html__('Title Highlight', 'tjcore'),
        ],
        'condition' => [
          'tj_gsap_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_title_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
        ],
        'condition' => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h2',
        'toggle'  => false,
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      '__tj_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '3', '4'],
        ],
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'   => esc_html__('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => esc_html__('Learn More', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => true,
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      'tj_project_tab_list',
      [
        'label' => esc_html__('Content List', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
          4 => __('Style 04', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );

    $repeater->add_control(
      'tj_project_image',
      [
        'label'   => esc_html__('Project Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_cat',
      [
        'label'       => esc_html__('Category title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Business', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'tj_project_cat_link',
      [
        'label' => esc_html__('Category Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ]
      ]
    );
    $repeater->add_control(
      'tj_project_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Event Management Platform', 'tjcore'),
        'rows' => 2,
      ]
    );
    $repeater->add_control(
      'tj_project_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Event Management Platform', 'tjcore'),
        'rows' => 3,
        'condition' => [
          'field_condition!' => ['1', '3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_btn',
      [
        'label'       => esc_html__('Button', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Learn more', 'tjcore'),
        'condition' => [
          'field_condition!' => ['1', '3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_project_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
      ]
    );

    $repeater->add_control(
      'tj_project_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
      ]
    );
    $repeater->add_control(
      'tj_project_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_project_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_project_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_project_link_type' => '2',
        ],
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );

    $repeater->add_control(
      'gsap_animation',
      [
        'label'        => esc_html__('Scroll Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition' => [
          'field_condition!' => ['2', '3', '4'],
        ],
      ]
    );

    $this->add_control(
      'tj_project_list',
      [
        'label' => '',
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_project_title' => tj_kses('Event Management Platform'),
            'tj_project_cat' => tj_kses('Business'),
          ],
          [
            'tj_project_title' => tj_kses('Digital Marketing Campaign'),
            'tj_project_cat' => tj_kses('Connect'),
          ],
          [
            'tj_project_title' => tj_kses('Interactive Learning Platform'),
            'tj_project_cat' => tj_kses('Empower'),
          ],
          [
            'tj_project_title' => tj_kses('Environmental Impact Dashboard'),
            'tj_project_cat' => tj_kses('Support'),
          ],
        ],
        'title_field' => '{{{ tj_project_title }}}',
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */


    $this->tj_section_style_controls('section_style', 'Section - Style', '.tj-el-section', ['1', '3', '4']);
    $this->tj_basic_style_controls('section_subtitle', 'SubTitle - Style', '.tj-el-subtitle', ['1', '3', '4']);
    $this->tj_basic_style_controls('section_title', 'Section Title - Style', '.sec-heading .tj-el-title', ['1', '3', '4']);

    $this->tj_button_style_controls_two('sec_button', 'Section Button', '.btn-area .tj-el-btn', '.btn-text', ['1', '3', '4']);
    $this->tj_icon_style_controls_two('sec_button_icon', 'Section Button Icon', '.btn-area .tj-el-btn', '.btn-icon', ['1', '3', '4']);



    // card style
    $this->tj_card_style_controls('project_card', 'Card- Style', '.tj-el-project');

    // title style
    $this->tj_basic_style_controls('project_title', 'Title - Style', '.tj-el-title');
    $this->tj_basic_style_controls('project_desc', 'Description - Style', '.tj-el-desc', ['1', '3']);

    // category style
    $this->tj_basic_style_controls('project_cat', 'Category - Style', '.tj-el-cat');

    // icon style
    $this->tj_icon_style_controls('project_icon', 'Icon Button - Style', '.tj-el-icon-btn', ['2']);

    // button style
    $this->tj_link_style_controls('button', 'Button - Style', '.tj-el-btn', '.btn-text', ['1', '3']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-btn', '.btn-icon', ['1', '3']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/project-list/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Project_list());
