<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Projects.
 */
class TJ_Projects extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-projects';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Projects', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-post tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'project',
      'projects',
      'tj project',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Projects Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Project Query
    $this->start_controls_section(
      'tj_project_query',
      [
        'label' => esc_html__('Project Query', 'tjcore'),
      ]
    );

    $post_type = 'projects';
    $taxonomy = 'projects-cat';

    $this->add_control(
      'posts_per_page',
      [
        'label' => esc_html__('Projects Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'default' => '6',
      ]
    );
    $this->add_control(
      'category',
      [
        'label' => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label' => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'multiple' => true,
        'options' => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label' => esc_html__('Include Project', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'options' => tj_get_all_types_post($post_type),
        'multiple' => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label' => esc_html__('Exclude Project', 'tjcore'),
        'type' => Controls_Manager::SELECT2,
        'options' => tj_get_all_types_post($post_type),
        'multiple' => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label' => esc_html__('Offset', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label' => esc_html__('Order By', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => array(
          'ID' => 'Post ID',
          'author' => 'Post Author',
          'title' => 'Title',
          'date' => 'Date',
          'modified' => 'Last Modified Date',
          'parent' => 'Parent Id',
          'rand' => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order' => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label' => esc_html__('Order', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          'asc' => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );

    $this->add_control(
      'tj_post_title_word',
      [
        'label'       => esc_html__('Title Word Limit', 'tjcore'),
        'description' => esc_html__('Set how many word you want to display!', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );

    $this->add_control(
      'tj_post_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'post_icon',
        'default'          => [
          'value'   => 'tji-arrow-right-big',
          'library' => 'tj',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'   => [
          'tj_design_style!' => ['2']
        ],
      ]
    );

    $this->add_control(
      'tj_category',
      [
        'label' => esc_html__('Enable Category?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_button',
      [
        'label' => esc_html__('Enable Button?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'separator' => 'before',
        'condition'   => [
          'tj_design_style' => ['2']
        ],
      ]
    );
    $this->add_control(
      'tj_project_btn',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'label_block' => true,
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('View Project', 'tjcore'),
        'condition'   => [
          'tj_button'       => 'yes',
          'tj_design_style' => ['2']
        ],
      ]
    );

    $this->add_control(
      'tj_pagination',
      [
        'label' => esc_html__('Enable Pagination?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );

    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_column_settings',
      [
        'label' => esc_html__('Column Settings', 'tjcore'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'desktop_column',
      [
        'label' => esc_html__('Columns for Desktop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 1200px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1', 'tjcore'),
          6 => esc_html__('2', 'tjcore'),
          4 => esc_html__('3', 'tjcore'),
          3 => esc_html__('4', 'tjcore'),
          2 => esc_html__('6', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'laptop_column',
      [
        'label' => esc_html__('Columns for Laptop', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 992px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1', 'tjcore'),
          6 => esc_html__('2', 'tjcore'),
          4 => esc_html__('3', 'tjcore'),
          3 => esc_html__('4', 'tjcore'),
          2 => esc_html__('6', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );

    $this->add_control(
      'tablet_column',
      [
        'label' => esc_html__('Columns for Tablet', 'tjcore'),
        'description' => esc_html__('Screen width equal to or greater than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1', 'tjcore'),
          6 => esc_html__('2', 'tjcore'),
          4 => esc_html__('3', 'tjcore'),
          3 => esc_html__('4', 'tjcore'),
          2 => esc_html__('6', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '6',
        'style_transfer' => true,
      ]
    );
    $this->add_control(
      'mobile_column',
      [
        'label' => esc_html__('Columns for Mobile', 'tjcore'),
        'description' => esc_html__('Screen width less than 768px', 'tjcore'),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
          12 => esc_html__('1', 'tjcore'),
          6 => esc_html__('2', 'tjcore'),
          4 => esc_html__('3', 'tjcore'),
          3 => esc_html__('4', 'tjcore'),
          2 => esc_html__('6', 'tjcore'),
        ],
        'separator' => 'before',
        'default' => '12',
        'style_transfer' => true,
      ]
    );

    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    // card style
    $this->tj_card_style_controls('project_card', 'Card- Style', '.tj-el-project');

    // title style
    $this->tj_basic_style_controls('project_title', 'Title - Style', '.tj-el-title');

    // category style
    $this->tj_basic_style_controls('project_cat', 'Category - Style', '.tj-el-cat');

    // icon style
    $this->tj_icon_style_controls('project_icon', 'Icon Button - Style', '.tj-el-icon-btn', ['2']);


    /**
     * Pagination Button Style Controls
     */
    $this->start_controls_section(
      'tj_pagination_button_style',
      [
        'label' => esc_html__('Pagination Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      \Elementor\Group_Control_Typography::get_type(),
      [
        'name'     => 'pagination_btn_typography',
        'selector' => '{{WRAPPER}} .tj-pagination ul li .page-numbers',
      ]
    );
    // Normal Style
    $this->start_controls_tabs('pagination_btn_tabs');

    $this->start_controls_tab(
      'pagination_btn_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'pagination_btn_text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_control(
      'pagination_btn_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers' => 'background-color: {{VALUE}};',
        ],
      ]
    );
    $this->end_controls_tab();

    // Hover/Active Style
    $this->start_controls_tab(
      'pagination_btn_hover',
      [
        'label' => esc_html__('Hover / Active', 'tjcore'),
      ]
    );

    $this->add_control(
      'pagination_btn_hover_text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers:hover, {{WRAPPER}} .tj-pagination ul li .page-numbers.current' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'pagination_btn_hover_bg_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers:hover, {{WRAPPER}} .tj-pagination ul li .page-numbers.current' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'pagination_btn_hover_border_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers:hover, {{WRAPPER}} .tj-pagination ul li .page-numbers.current' => 'border-color: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_tab();
    $this->end_controls_tabs();
    // Border
    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'pagination_btn_border',
        'selector' => '{{WRAPPER}} .tj-pagination ul li .page-numbers',
      ]
    );

    // Border radius
    $this->add_control(
      'pagination_btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'selectors'  => [
          '{{WRAPPER}} .tj-pagination ul li .page-numbers' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/projects/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {}
}
$widgets_manager->register(new TJ_Projects());
