<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Services Carousel.
 */
class TJ_Service_Slider extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-service-slider';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Service Slider', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-post-slider tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'service',
      'services',
      'tj service',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {

    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Slider Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_service_tab_list',
      [
        'label' => esc_html__('Content List', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();

    $repeater->add_control(
      'field_condition',
      [
        'label' => __('Field condition', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'options' => [
          1 => __('Style 01', 'tjcore'),
          2 => __('Style 02', 'tjcore'),
          3 => __('Style 03', 'tjcore'),
          4 => __('Style 04', 'tjcore'),
        ],
        'default' => '1',
        'frontend_available' => true,
        'style_transfer' => true,
      ]
    );

    $repeater->add_control(
      'tj_service_image',
      [
        'label'   => esc_html__('Service Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition'   => [
          'field_condition!' => ['2', '4'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_icon',
      [
        'label' => __('Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'service_icon',
        'default' => [
          'value' => 'tji-service-1',
          'library' => 'tj',
        ],
        'condition'   => [
          'field_condition!' => ['3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Business Strategy Development', 'tjcore'),
        'rows' => 3,
      ]
    );

    $repeater->add_control(
      'tj_service_desc',
      [
        'label'       => esc_html__('Description', 'tjcore'),
        'type'        => Controls_Manager::TEXTAREA,
        'default'     => esc_html__('Through a combination of data-driven insights and innovative approaches, we work closely with you to develop customized.', 'tjcore'),
        'rows' => 3,
        'condition'   => [
          'field_condition!' => ['3'],
        ],
      ]
    );
    $repeater->add_control(
      'tj_service_btn',
      [
        'label'       => esc_html__('Button', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Learn more', 'tjcore'),
        'condition'   => [
          'field_condition!' => ['3'],
        ],
      ]
    );

    $repeater->add_control(
      'tj_service_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
      ]
    );

    $repeater->add_control(
      'tj_service_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
      ]
    );
    $repeater->add_control(
      'tj_service_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_service_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'tj_service_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_service_link_type' => '2',
        ],
      ]
    );

    $this->add_control(
      'tj_service_list',
      [
        'label' => '',
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_service_title' => tj_kses('Business Strategy Development'),
            'tj_service_desc' => tj_kses('Through a combination of data-driven insights and innovative approaches, we work closely with you to develop customized.'),
          ],
          [
            'tj_service_title' => tj_kses('Customer Experience Solutions'),
            'tj_service_desc' => tj_kses('Developing personalized customer journeys to increase satisfaction and loyalty of our expansion to keep competitive.'),
          ],
          [
            'tj_service_title' => tj_kses('Sustainability and ESG Consulting'),
            'tj_service_desc' => tj_kses('Provide tailored strategies that not only drive long-term value but also build trust with stakeholders, investors.'),
          ],
          [
            'tj_service_title' => tj_kses('Training and Development Programs'),
            'tj_service_desc' => tj_kses('Training and Development Programs are designed to empower employees with the skills, knowledge, and tools they need'),
          ],
        ],
        'title_field' => '{{{ tj_service_title }}}',
      ]
    );

    $this->end_controls_section();

    // animation
    $this->start_controls_section(
      'tj_animation_group',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',

      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInLeftBig'  => esc_html__('Fade In Left Big', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade In Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();


    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 300,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 2000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();


    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('service_card', 'Card- Style', '.tj-el-service');

    // icon style
    $this->tj_icon_style_controls('service_icon', 'Icon - Style', '.tj-el-icon', ['2', '3', '4']);
    $this->tj_icon_style_controls_two('service_icon2', 'Icon - Style', '.tj-el-service', '.tj-el-icon', ['1', '3']);

    // title style
    $this->tj_basic_style_controls('service_title', 'Title - Style', '.tj-el-title', ['2', '4']);
    $this->tj_basic_style_controls_two('service_title2', 'Title - Style', '.tj-el-service', '.tj-el-title', ['1', '3']);

    // description style
    $this->tj_basic_style_controls('service_desc', 'Description - Style', '.tj-el-desc', ['2', '3', '4']);
    $this->tj_basic_style_controls_two('service_desc2', 'Description - Style', '.tj-el-service', '.tj-el-desc', ['1', '3']);

    // button style
    $this->tj_link_style_controls('button', 'Button - Style', '.tj-el-btn', '.btn-text', ['2', '3', '4']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-btn', '.btn-icon', ['2', '4']);

    $this->tj_link_style_controls('button2', 'Button - Style', '.tj-el-service', '.tj-el-btn .btn-text', ['1', '3']);
    $this->tj_icon_style_controls_two('button_icon2', 'Button Icon - Style', '.tj-el-service', '.tj-el-btn .btn-icon', ['1', '3']);

    // dot style
    $this->tj_swiper_dot_style_controls('swiper_dots', 'Dots - Style', '.swiper-pagination-area');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/service-slider/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Service_Slider());
