<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Teams.
 */
class TJ_Team_List extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-team-list';
  }

  // widget title.
  public function get_title() {
    return __('TJ Team List', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-person tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'teams',
      'team',
      'ts team',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // team style
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Team Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Team Members
    $this->start_controls_section(
      'tj_team_members',
      [
        'label' => esc_html__('Members', 'tjcore'),
      ]
    );

    $this->add_control(
      'tj_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Default Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );

    // repeater 
    $repeater = new Repeater();
    $repeater->start_controls_tabs('members_tabs');
    $repeater->start_controls_tab(
      'member_info_tab',
      [
        'label' => esc_html__('Information', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'tj_member_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_member_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'tj_member_designation',
      [
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'label' => esc_html__('Designation', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater->add_control(
      'member_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'tj_member_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
      ]
    );

    // animation
    $repeater->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $repeater->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $repeater->end_controls_tab();
    $repeater->start_controls_tab(
      'member_socials_tab',
      [
        'label' => esc_html__('Socials', 'tjcore'),
      ]
    );
    $repeater->add_control(
      'show_member_socials',
      [
        'label' => __('Show socials option?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'tjcore'),
        'label_off' => __('No', 'tjcore'),
        'return_value' => 'yes',
      ]
    );
    $repeater->add_control(
      'website_link',
      [
        'label' => esc_html__('Website', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'email_link',
      [
        'label' => esc_html__('Email', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'phone_link',
      [
        'label' => esc_html__('Phone', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'facebook_link',
      [
        'label' => esc_html__('Facebook', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.facebook.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'twitter_link',
      [
        'label' => esc_html__('Twitter', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://x.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'instagram_link',
      [
        'label' => esc_html__('Instagram', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.instagram.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'linkedin_link',
      [
        'label' => esc_html__('Linkedin', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.linkedin.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'pinterest_link',
      [
        'label' => esc_html__('Pinterest', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'youtube_link',
      [
        'label' => esc_html__('YouTube', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'vimeo_link',
      [
        'label' => esc_html__('Vimeo', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'github_link',
      [
        'label' => esc_html__('Github', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'flickr_link',
      [
        'label' => esc_html__('Flickr', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'behance_link',
      [
        'label' => esc_html__('Behance', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->add_control(
      'dribbble_link',
      [
        'label' => esc_html__('Dribbble', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'show_member_socials' => 'yes'
        ]
      ]
    );
    $repeater->end_controls_tab();
    $repeater->end_controls_tabs();
    // REPEATER
    $this->add_control(
      'team_member_list',
      [
        'show_label' => false,
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'tj_member_name' => esc_html__('Mike Hardson', 'tjcore'),
            'tj_member_designation' => esc_html__('Manager', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('David Cooper', 'tjcore'),
            'tj_member_designation' => esc_html__('Co Founder', 'tjcore'),
          ],
          [
            'tj_member_name' => esc_html__('Lucas Damian', 'tjcore'),
            'tj_member_designation' => esc_html__('Architect', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_member_name }}}',
        'condition' => [
          'tj_design_style!' => ['2']
        ]
      ]
    );

    $repeater2 = new Repeater();
    $repeater2->add_control(
      'tj_member2_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater2->add_control(
      'tj_member2_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater2->add_control(
      'tj_member2_designation',
      [
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'label' => esc_html__('Designation', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater2->add_control(
      'member2_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );
    $repeater2->add_control(
      'tj_member2_btn_text',
      [
        'label' => esc_html__('Button Text', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Know More', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $repeater2->add_control(
      'tj_member2_btn_icon',
      [
        'label' => __('Button Icon', 'tjcore'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'label_block' => false,
        'fa4compatibility' => 'btn_icon',
        'skin'             => 'inline',
        'default' => [
          'value' => 'tji-arrow-right-long',
          'library' => 'tj',
        ],
      ]
    );

    // animation
    $repeater2->add_control(
      'tj_animation2',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $repeater2->add_control(
      'tj_animation2_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation2' => 'yes',
        ],
      ]
    );
    $repeater2->add_control(
      'tj_animation2_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation2' => 'yes',
        ]
      ]
    );
    // REPEATER
    $this->add_control(
      'team_member2_list',
      [
        'show_label' => false,
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater2->get_controls(),
        'default' => [
          [
            'tj_member2_name' => esc_html__('Mike Hardson', 'tjcore'),
            'tj_member2_designation' => esc_html__('Manager', 'tjcore'),
          ],
          [
            'tj_member2_name' => esc_html__('David Cooper', 'tjcore'),
            'tj_member2_designation' => esc_html__('Co Founder', 'tjcore'),
          ],
          [
            'tj_member2_name' => esc_html__('Lucas Damian', 'tjcore'),
            'tj_member2_designation' => esc_html__('Architect', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ tj_member2_name }}}',
        'condition' => [
          'tj_design_style!' => ['1']
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('team_card', 'Card - Style', '.tj-el-team .team-item-inner', ['2']);

    // title style
    $this->tj_basic_style_controls('team_title', 'Title - Style', '.tj-el-team .title');

    // desgination style
    $this->tj_basic_style_controls('team_desig', 'Designation - Style', '.tj-el-team .designation');

    // social icon style
    $this->tj_icon_style_controls('social_icon', 'Social Icon - Style', '.social-links ul li a', ['2']);

    // button icon style
    $this->tj_icon_style_controls('team_btn_icon', 'Icon button - Style', '.tj-el-team .team-link', ['2']);

    // image style
    $this->tj_section_style_controls('team_imagewrap', 'Image Wrap - Style', '.tj-el-image .team-img', ['2']);
    $this->tj_img_style_controls('team_image', 'Image - Style', '.tj-el-image .team-img', ['2']);

    // image style
    $this->tj_section_style_controls('team_imagewrap_2', 'Image Wrap - Style', '.tj-el-team .team-img', ['1']);
    $this->tj_img_style_controls('team_image_2', 'Image - Style', '.tj-el-team .team-img', ['1']);

    // button style
    $this->tj_link_style_controls('button', 'Button - Style', '.text-btn', '.btn-text', ['1']);
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.text-btn', '.btn-icon', ['1']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/team-list/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Team_List());
