<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Teams.
 */
class TJ_Team extends Widget_Base {

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name() {
    return 'tj-team';
  }

  // widget title.
  public function get_title() {
    return __('TJ Team', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-person tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'teams',
      'team',
      'ts team',
      'ts',
      'ts addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // team style
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Team Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Team Members
    $this->start_controls_section(
      'tj_team_member',
      [
        'label' => esc_html__('Member', 'tjcore'),
      ]
    );
    $this->start_controls_tabs('tj_members_tabs');
    $this->start_controls_tab(
      'tj_member_info_tab',
      [
        'label' => esc_html__('Information', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'type' => Controls_Manager::MEDIA,
        'label' => esc_html__('Image', 'tjcore'),
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $this->add_control(
      'tj_media_link',
      [
        'label'        => esc_html__('Enable media link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_name',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Name', 'tjcore'),
        'default' => esc_html__('Savannah Nguyen', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $this->add_control(
      'tj_name_link',
      [
        'label'        => esc_html__('Enable name link?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => 'yes',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_designation',
      [
        'label' => esc_html__('Designation', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('Co. Founder', 'tjcore'),
        'label_block' => true,
        'dynamic' => [
          'active' => true,
        ]
      ]
    );
    $this->add_control(
      'tj_url',
      [
        'label' => esc_html__('Link', 'tjcore'),
        'type' => Controls_Manager::URL,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => [
          'url' => '#',
          'is_external' => false,
          'nofollow' => false,
        ],
        'dynamic'     => [
          'active' => true,
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_show_button',
      [
        'label'        => esc_html__('Show member button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'separator'    => 'before',
        'condition' => [
          'tj_url[url]!' => "",
        ],
      ]
    );
    $this->add_control(
      'tj_button_text',
      [
        'type' => Controls_Manager::TEXT,
        'label' => esc_html__('Button Text', 'tjcore'),
        'default' => esc_html__('Read More', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
        'condition' => [
          'tj_url[url]!' => "",
          'tj_show_button' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Button Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => 'tji-arrow-right-long',
          'library' => 'tji',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition' => [
          'tj_url[url]!' => "",
          'tj_show_button' => 'yes',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'tj_member_socials_tab',
      [
        'label' => esc_html__('Socials', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_show_member_socials',
      [
        'label' => __('Show socials option?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __('Yes', 'tjcore'),
        'label_off' => __('No', 'tjcore'),
        'return_value' => 'yes',
      ]
    );
    $this->add_control(
      'tj_website_link',
      [
        'label' => esc_html__('Website', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_email_link',
      [
        'label' => esc_html__('Email', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_phone_link',
      [
        'label' => esc_html__('Phone', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_facebook_link',
      [
        'label' => esc_html__('Facebook', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.facebook.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_twitter_link',
      [
        'label' => esc_html__('Twitter', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://x.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_instagram_link',
      [
        'label' => esc_html__('Instagram', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.instagram.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_linkedin_link',
      [
        'label' => esc_html__('Linkedin', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default' => esc_attr('https://www.linkedin.com/'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_pinterest_link',
      [
        'label' => esc_html__('Pinterest', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_youtube_link',
      [
        'label' => esc_html__('YouTube', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_vimeo_link',
      [
        'label' => esc_html__('Vimeo', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_github_link',
      [
        'label' => esc_html__('Github', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_flickr_link',
      [
        'label' => esc_html__('Flickr', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_behance_link',
      [
        'label' => esc_html__('Behance', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_dribbble_link',
      [
        'label' => esc_html__('Dribbble', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'label_block' => true,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'     => [
          'active' => false,
        ],
        'condition' => [
          'tj_show_member_socials' => 'yes'
        ]
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    // animation
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
          'fadeInRightBig'  => esc_html__('Fade Right Big', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('team_card', 'Card- Style', '.tj-el-team .box');

    // title style
    $this->tj_basic_style_controls('team_title', 'Title - Style', '.tj-el-team .title');

    // desgination style
    $this->tj_basic_style_controls('team_desig', 'Designation - Style', '.tj-el-team .designation');

    // social icon style
    $this->tj_icon_style_controls('social_icon', 'Social Icon - Style', '.social-links ul li a');

    // email icon style
    $this->tj_icon_style_controls('email_icon', 'Email Icon - Style', '.tj-el-team .mail-at', ['2']);

    $this->tj_button_style_controls_two('button', 'Button - Style', '.tj-el-btn', '.btn-text');
    $this->tj_icon_style_controls_two('button_icon', 'Button Icon - Style', '.tj-el-btn', '.btn-icon');
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();
    extract($settings);
    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/team/style-' . $tj_design_style . '.php';
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Team());
