<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for video.
 */
class TJ_Video_Info extends Widget_Base
{

  use \TJCore\TJCore_Elelmentor_Trait;

  // widget name
  public function get_name()
  {
    return 'tj-video-info';
  }

  // widget title.
  public function get_title()
  {
    return __('TJ Video Info', 'tjcore');
  }

  // widget icon.
  public function get_icon()
  {
    return 'eicon-video tj-icon';
  }

  // Widget categories.
  public function get_categories()
  {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends()
  {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends()
  {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords()
  {
    return [
      'video',
      'video info',
      'tj video info',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url()
  {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls()
  {


    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Video Style', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();


    // tj_video_circle
    $this->start_controls_section(
      'tj_video_circle_tab',
      [
        'label' => esc_html__('Video', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['4'],
        ],
      ]
    );

    $this->add_control(
      'tj_video_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'type' => Controls_Manager::ICONS,
        'default' => [
          'value' => 'tji-play',
          'library' => 'tji',
        ],
        'fa4compatibility' => 'video_icon'
      ]
    );
    $this->add_control(
      'tj_video_link',
      [
        'label' => esc_html__('Video Link', 'tjcore'),
        'type' => Controls_Manager::TEXT,
        'default' => esc_html__('https://www.youtube.com/watch?v=MLpWrANjFbI', 'tjcore'),
        'placeholder' => esc_html__('Type your video link here', 'tjcore'),
        'label_block' => true
      ]
    );

    $this->add_control(
      'tj_video_title',
      [
        'label' => __('Title', 'tjcore'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Play your reels', 'tjcore'),
        'label_block' => true,
        'condition' => [
          'tj_design_style!' => ['1', '2'],
        ],
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'tj_video_slider_content',
      [
        'label' => esc_html__('Video Slider', 'tjcore'),
        'condition' => [
          'tj_design_style!' => ['1', '2', '3'],
        ],
      ]
    );

    $repeater = new \Elementor\Repeater();

    $repeater->add_control(
      'card_image',
      [
        'label' => __('Image', 'tjcore'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
          'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
      ]
    );

    $repeater->add_control(
      'card_video',
      [
        'label' => __('Video Link (YouTube/Vimeo)', 'tjcore'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => 'https://youtu.be/xxxxxx',
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'card_title',
      [
        'label' => __('Title', 'tjcore'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Card Title', 'tjcore'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'card_link',
      [
        'label' => __('Card Link', 'tjcore'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => 'https://your-link.com',
        'label_block' => true,
      ]
    );

    $this->add_control(
      'tj_video_cards',
      [
        'label' => __('Cards', 'tjcore'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [],
        'title_field' => '{{{ card_title }}}',
      ]
    );

    $this->end_controls_section();

    $this->start_controls_section(
      'tj_video_animatin',
      [
        'label' => esc_html__('Animation', 'tjcore'),
      ]
    );

    // animation    
    $this->add_control(
      'tj_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );

    // animation name
    $this->add_control(
      'tj_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeIn'      => esc_html__('Fade In', 'tjcore'),
          'fadeDown'    => esc_html__('Fade Down', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes',
        ],
      ]
    );

    // animation delay
    $this->add_control(
      'tj_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'separator' => 'after',
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_animation' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();



    // slider settings
    $this->start_controls_section(
      '__tj_slider_settings',
      [
        'label' => esc_html__('Slider Settings', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style!' => ['1', '2', '3'],
        ],
      ]
    );
    $this->add_control(
      'slide_loop',
      [
        'label'        => esc_html__('Is Loop?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider item loop?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_dot',
      [
        'label'        => esc_html__('Is Dots?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to show slider dots?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay',
      [
        'label'        => esc_html__('Is Autoplay?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'description'  => esc_html__('Do you want to make this slider auto play?', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );
    $this->add_control(
      'slide_autoplay_Delay',
      [
        'label'       => esc_html__('Autoplay Delay', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'description' => esc_html__('Set slider autoplay delay.', 'tjcore'),
        'min'         => 1000,
        'max'         => 10000,
        'step'        => 100,
        'default'     => 5000,
        'condition'   => [
          'slide_autoplay' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */

    // card style
    $this->tj_card_style_controls('video_card', 'Card- Style', '.tj-el-card', ['1', '2', '3']);
    // image style
    $this->tj_img_style_controls('video_image', 'Image - Style', '.tj-el-image', ['1', '2', '3']);
    $this->tj_basic_style_controls('video_title', 'Name - Style', '.tj-el-title', ['1', '2', '3']);

    // icon style
    $this->tj_icon_style_controls('video_icon', 'Video Icon - Style', '.video-popup');

    // dots style
    $this->tj_swiper_dot_style_controls('swiper_dots', 'Dots - Style', '.swiper-pagination-area', ['1', '2', '3']);
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render()
  {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/video-btn/style-' . $tj_design_style . '.php';
  }
}
$widgets_manager->register(new TJ_Video_Info());
