<?php

/**
 * Animation Effects extension class.
 */

namespace TJ_Core\Extensions;

use Elementor\Controls_Manager;
use Elementor\Plugin;

defined('ABSPATH') || die();

class TJ_Pin_Effects {

  public static function init() {
    //ping area controls
    add_action('elementor/element/section/section_advanced/after_section_end', [
      __CLASS__,
      'register_ping_area_controls'
    ]);

    add_action('elementor/element/container/section_layout/after_section_end', [
      __CLASS__,
      'register_ping_area_controls'
    ]);
  }

  public static function register_ping_area_controls($element) {
    $element->start_controls_section(
      '_section_pin-area',
      [
        'label' => sprintf('<i class="tj-logo"></i> %s', __('Pin Element', 'tjcore')),
        'tab'   => Controls_Manager::TAB_ADVANCED,
      ]
    );

    $element->add_control(
      'tj_enable_pin_area',
      [
        'label'              => esc_html__('Enable Pin', 'tjcore'),
        'type'               => Controls_Manager::SWITCHER,
        'frontend_available' => true,
        'render_type'        => 'none',
        'return_value'       => 'yes',
      ]
    );

    $element->add_control(
      'tj_pin_alert',
      [
        'label'           => esc_html__('Important Note', 'tjcore'),
        'type'            => Controls_Manager::RAW_HTML,
        'raw'             => esc_html__('Please use full width Container to work properly and see the result in view mode.', 'tjcore'),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
        'condition'       => ['tj_enable_pin_area!' => ''],
        'render_type'     => 'none',
      ]
    );

    $element->add_control(
      'tj_pin_area_trigger',
      [
        'label'       => esc_html__('Pin Wrapper', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'default'     => '',
        'options'     => [
          ''       => esc_html__('Default', 'tjcore'),
          'custom' => esc_html__('Custom', 'tjcore'),
        ],
        'condition'   => ['tj_enable_pin_area!' => ''],
        'render_type' => 'none',
      ]
    );

    $element->add_control(
      'tj_custom_pin_area',
      [
        'label'              => esc_html__('Custom Pin Area', 'tjcore'),
        'description'        => esc_html__('Add the section class where the element will be pin. please use the parent section or container class.', 'tjcore'),
        'type'               => Controls_Manager::TEXT,
        'ai'                 => false,
        'placeholder'        => esc_html__('.pin_area', 'tjcore'),
        'frontend_available' => true,
        'render_type'        => 'none',
        'condition'          => [
          'tj_pin_area_trigger' => 'custom',
          'tj_enable_pin_area!' => '',
        ]
      ]
    );

    $element->add_control(
      'tj_pin_end_trigger',
      [
        'label'              => esc_html__('End Trigger', 'tjcore'),
        'type'               => Controls_Manager::TEXT,
        'ai'                 => false,
        'placeholder'        => esc_html__('.end_trigger', 'tjcore'),
        'frontend_available' => true,
        'render_type'        => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
        'separator'          => 'after',
      ]
    );

    $element->add_control(
      'tj_pin_status',
      [
        'label'     => esc_html__('Pin', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'true',
        'options'   => [
          'true'   => esc_html__('True', 'tjcore'),
          'false'  => esc_html__('False', 'tjcore'),
          'custom' => esc_html__('Custom', 'tjcore'),
        ],
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_custom',
      [
        'label'       => esc_html__('Custom Pin', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'frontend_available' => true,
        'render_type' => 'none',
        'placeholder' => esc_html__('.pin_class', 'tjcore'),
        'condition'   => [
          'tj_pin_status' => 'custom',
          'tj_enable_pin_area!' => '',
        ]
      ]
    );

    $element->add_control(
      'tj_pin_spacing',
      [
        'label'     => esc_html__('Pin Spacing', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'false',
        'options'   => [
          'true'   => esc_html__('True', 'tjcore'),
          'false'  => esc_html__('False', 'tjcore'),
          'custom' => esc_html__('Custom', 'tjcore'),
        ],
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_spacing_custom',
      [
        'label'       => esc_html__('Custom Pin Spacing', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'frontend_available' => true,
        'render_type' => 'none',
        'placeholder' => esc_html__('.custom-class', 'tjcore'),
        'condition'   => [
          'tj_pin_spacing' => 'custom',
          'tj_enable_pin_area!' => '',
        ]
      ]
    );

    $element->add_control(
      'tj_pin_type',
      [
        'label'     => esc_html__('Pin Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'transform',
        'options'   => [
          'fixed'   => esc_html__('Fixed', 'tjcore'),
          'transform'  => esc_html__('Transform', 'tjcore'),
        ],
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_scrub',
      [
        'label'     => esc_html__('Pin Scrub', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'false',
        'options'   => [
          'true'   => esc_html__('True', 'tjcore'),
          'false'  => esc_html__('False', 'tjcore'),
          'number'  => esc_html__('Number', 'tjcore'),
        ],
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_scrub_number',
      [
        'label' => esc_html__('Scrub Number', 'tjcore'),
        'type' => Controls_Manager::NUMBER,
        'min' => 1,
        'max' => 10,
        'default' => 1,
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'   => [
          'tj_pin_scrub' => 'number',
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_markers',
      [
        'label'     => esc_html__('Pin Markers', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'false',
        'options'   => [
          'true'   => esc_html__('True', 'tjcore'),
          'false'  => esc_html__('False', 'tjcore'),
        ],
        'frontend_available' => true,
        'render_type' => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_area_start',
      [
        'label'              => esc_html__('Start', 'tjcore'),
        'description'        => esc_html__('First value is element position, Second value is display position', 'tjcore'),
        'type'               => Controls_Manager::SELECT,
        'separator'          => 'before',
        'default'            => 'top top',
        'frontend_available' => true,
        'options'            => [
          'top top'       => esc_html__('Top Top', 'tjcore'),
          'top center'    => esc_html__('Top Center', 'tjcore'),
          'top bottom'    => esc_html__('Top Bottom', 'tjcore'),
          'center top'    => esc_html__('Center Top', 'tjcore'),
          'center center' => esc_html__('Center Center', 'tjcore'),
          'center bottom' => esc_html__('Center Bottom', 'tjcore'),
          'bottom top'    => esc_html__('Bottom Top', 'tjcore'),
          'bottom center' => esc_html__('Bottom Center', 'tjcore'),
          'bottom bottom' => esc_html__('Bottom Bottom', 'tjcore'),
          'custom'        => esc_html__('custom', 'tjcore'),
        ],
        'render_type'        => 'none',
        'condition'          => ['tj_enable_pin_area!' => ''],

      ]
    );

    $element->add_control(
      'tj_pin_area_start_custom',
      [
        'label'              => esc_html__('Custom', 'tjcore'),
        'type'               => Controls_Manager::TEXT,
        'default'            => esc_html__('top top', 'tjcore'),
        'placeholder'        => esc_html__('top top+=100', 'tjcore'),
        'frontend_available' => true,
        'render_type'        => 'none',
        'condition'          => [
          'tj_enable_pin_area!' => '',
          'tj_pin_area_start'   => 'custom',
        ],
      ]
    );

    $element->add_control(
      'tj_pin_area_end',
      [
        'label'              => esc_html__('End', 'tjcore'),
        'description'        => esc_html__('First value is element position, Second value is display position', 'tjcore'),
        'type'               => Controls_Manager::SELECT,
        'separator'          => 'before',
        'default'            => 'bottom top',
        'frontend_available' => true,
        'render_type'        => 'none',
        'options'            => [
          'top top'       => esc_html__('Top Top', 'tjcore'),
          'top center'    => esc_html__('Top Center', 'tjcore'),
          'top bottom'    => esc_html__('Top Bottom', 'tjcore'),
          'center top'    => esc_html__('Center Top', 'tjcore'),
          'center center' => esc_html__('Center Center', 'tjcore'),
          'center bottom' => esc_html__('Center Bottom', 'tjcore'),
          'bottom top'    => esc_html__('Bottom Top', 'tjcore'),
          'bottom center' => esc_html__('Bottom Center', 'tjcore'),
          'bottom bottom' => esc_html__('Bottom Bottom', 'tjcore'),
          'custom'        => esc_html__('custom', 'tjcore'),
        ],
        'condition'          => ['tj_enable_pin_area!' => ''],
      ]
    );

    $element->add_control(
      'tj_pin_area_end_custom',
      [
        'label'              => esc_html__('Custom', 'tjcore'),
        'type'               => Controls_Manager::TEXT,
        'frontend_available' => true,
        'render_type'        => 'none',
        'default'            => esc_html__('bottom top', 'tjcore'),
        'placeholder'        => esc_html__('bottom top+=100', 'tjcore'),
        'condition'          => [
          'tj_enable_pin_area!' => '',
          'tj_pin_area_end'     => 'custom',
        ],
      ]
    );

    $dropdown_options = [
      '' => esc_html__('None', 'tjcore'),
    ];

    $excluded_breakpoints = [
      'laptop',
      'tablet_extra',
      'widescreen',
    ];

    foreach (Plugin::$instance->breakpoints->get_active_breakpoints() as $breakpoint_key => $breakpoint_instance) {
      // Exclude the larger breakpoints from the dropdown selector.
      if (in_array($breakpoint_key, $excluded_breakpoints, true)) {
        continue;
      }

      $dropdown_options[$breakpoint_key] = sprintf(
        /* translators: 1: Breakpoint label, 2: `>` character, 3: Breakpoint value. */
        esc_html__('%1$s (%2$s %3$dpx)', 'tjcore'),
        $breakpoint_instance->get_label(),
        '>',
        $breakpoint_instance->get_value()
      );
    }

    $element->add_control(
      'tj_pin_breakpoint',
      [
        'label'              => esc_html__('Breakpoint', 'tjcore'),
        'type'               => Controls_Manager::SELECT,
        'separator'          => 'before',
        'description'        => esc_html__('Note: Choose at which breakpoint Pin element will work.', 'tjcore'),
        'options'            => $dropdown_options,
        'frontend_available' => true,
        'render_type'        => 'none',
        'default'            => 'mobile',
        'condition'          => ['tj_enable_pin_area!' => ''],
      ]
    );

    $element->end_controls_section();
  }
}
TJ_Pin_Effects::init();
