<?php

namespace TJCore;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


/**
 * Element Common Functions
 */
trait TJCore_Elelmentor_Trait
{
    /**
     * @param null $control_id
     * @param string $control_name
     * @param string $selector
     */


    /*
    *  Section style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_section_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_area_styling',
            $section_args
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tj_' . $control_id . 'area_background',
                'label' => esc_html__('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . 'area_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_area_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_area_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_area_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Basic style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_basic_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_styling',
            $section_args
        );
        $this->start_controls_tabs('tj_' . $control_id . '_basic_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_text_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_text_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_text_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_htext_color',
            [
                'label' => esc_html__('Highlighter Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => esc_html__('If element has span tag, Hightlighter color will work.', 'tjcore'),
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' span ' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_text_hvr_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_bg_hcolor',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_hvr_text_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_hvr_htext_color',
            [
                'label' => esc_html__('Highlighter Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'description' => esc_html__('If element has span tag, Hightlighter color will work.', 'tjcore'),
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) span ' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'tj_' . $control_id . '_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_typography',
                'label' => esc_html__('Typography', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Basic style control two
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    4. $control_selector2 -> Selector Class or ID 2
    */
    protected function tj_basic_style_controls_two($control_id = null, $control_name = null, $control_selector = null, $control_selector2 = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_styling',
            $section_args
        );

        $this->start_controls_tabs('tj_' . $control_id . '_basic_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_text_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_text_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_text_hcolor',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_bg_hover_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2,
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_typography',
                'label' => esc_html__('Typography', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Button style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_button_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_button_styling',
            $section_args
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_typography',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );

        $this->start_controls_tabs('tj_' . $control_id . '_button_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_btn_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_btn_normal_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_btn_normal_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_btn_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_btn_hover_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_btn_hover_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_btn_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_hover_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tj_' . $control_id . '_btn_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_border_radius',
            [
                'label' => __('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Button style control two
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    4. $control_selector2 -> Selector Class or ID 2
    */
    protected function tj_button_style_controls_two($control_id = null, $control_name = null, $control_selector = null, $control_selector2 = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_button',
            $section_args
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_typography',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );
        $this->start_controls_tabs('tj_' . $control_id . '_button_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_btn_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_btn_normal_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_btn_normal_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ',
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_btn_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_btn_hover_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'    => 'tj_' . $control_id . '_btn_hover_bg_color',
                'label' => __('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ',
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_btn_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_hover_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tj_' . $control_id . '_btn_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_btn_normal_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_border_radius',
            [
                'label' => __('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_btn_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function tj_link_style_controls($control_id = null, $control_name = null, $control_selector = null, $control_selector2 = null, $condition = null)
    {
        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_link',
            $section_args
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_typography',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );

        $this->start_controls_tabs('tj_' . $control_id . '_link_tabs');

        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_link_normal', [
            'label' => esc_html__('Normal', 'tjcore'),
        ]);

        $this->add_control(
            'tj_' . $control_id . '_link_normal_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_link_hover', [
            'label' => esc_html__('Hover', 'tjcore'),
        ]);

        $this->add_control(
            'tj_' . $control_id . '_link_hover_text_color',
            [
                'label' => esc_html__('Text Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    /*
    *  Icon style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_icon_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }


        $this->start_controls_section(
            'tj_' . $control_id . '_media_style',
            $section_args
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_size',
            [
                'label' => esc_html__('Size', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' svg' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->start_controls_tabs('tj_' . $control_id . '_icon_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_icon_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_normal_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' svg' => 'fill: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_normal_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_icon_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_hover_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) svg' => 'fill: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_hover_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_hover_border',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_hover_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tj_' . $control_id . '_icon_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_width',
            [
                'label' => esc_html__('Width', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'width: {{SIZE}}{{UNIT}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_height',
            [
                'label' => esc_html__('Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'height: {{SIZE}}{{UNIT}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_lheight',
            [
                'label' => esc_html__('Line Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'line-height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_display',
            [
                'label' => __('Display', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => __('Default', 'tjcore'),
                    'block' => __('Block', 'tjcore'),
                    'inline-block' => __('Inline Block', 'tjcore'),
                    'inline' => __('Inline', 'tjcore'),
                ],
                'selectors'    => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'display: {{VALUE}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_align',
            [
                'label' => __('Icon Align', 'tjcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __('Left', 'tjcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'tjcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => __('Right', 'tjcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'text-align: {{VALUE}} !important;',
                ]
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Icon style control two
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    4. $control_selector2 -> Selector Class or ID 2
    */
    protected function tj_icon_style_controls_two($control_id = null, $control_name = null, $control_selector = null, $control_selector2 = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_icon_style',
            $section_args
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_size',
            [
                'label' => esc_html__('Size', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'font-size: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 . ' svg' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->start_controls_tabs('tj_' . $control_id . '_icon_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_icon_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_normal_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 . ' i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 . ' svg' => 'fill: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_normal_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_icon_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_control(
            'tj_' . $control_id . '_hover_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 . ' i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 . ' svg' => 'fill: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_hover_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_icon_hover_border',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2 => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_hover_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' . $control_selector2,
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'tj_' . $control_id . '_icon_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_icon_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2,
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_width',
            [
                'label' => esc_html__('Width', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'width: {{SIZE}}{{UNIT}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_height',
            [
                'label' => esc_html__('Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'height: {{SIZE}}{{UNIT}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_lheight',
            [
                'label' => esc_html__('Line Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 600,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'line-height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_display',
            [
                'label' => __('Display', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => __('Default', 'tjcore'),
                    'block' => __('Block', 'tjcore'),
                    'inline-block' => __('Inline Block', 'tjcore'),
                    'inline' => __('Inline', 'tjcore'),
                ],
                'selectors'    => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'display: {{VALUE}} !important;',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_icon_align',
            [
                'label' => __('Icon Align', 'tjcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __('Left', 'tjcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'tjcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => __('Right', 'tjcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} ' . $control_selector . ' ' . $control_selector2 => 'text-align: {{VALUE}} !important;',
                ]
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Card style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_card_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_card_styling',
            $section_args
        );
        $this->start_controls_tabs('tj_' . $control_id . '_card_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_card_normal', ['label' => esc_html__('Normal', 'tjcore')]);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tj_' . $control_id . '_card_background',
                'label' => esc_html__('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_card_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_card_hover', ['label' => esc_html__('Hover', 'tjcore')]);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tj_' . $control_id . '_card_hvr_background',
                'label' => esc_html__('Background Color', 'tjcore'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image', 'video'],
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->add_control(
            'tj_' . $control_id . '_card_hvr_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus) ' => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_card_hvr_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => '{{WRAPPER}} ' . $control_selector . ':is(:hover, :focus)',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_card_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . '',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_card_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_card_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_card_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . '' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /*
    *  Hero Slider style control
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */
    protected function tj_slider_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {
        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }
        $this->start_controls_section(
            'tj_' . $control_id . '_slide_styling',
            $section_args
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_height',
            [
                'label' => esc_html__('Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'responsive' => true,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_size',
            [
                'label' => esc_html__('Background Size', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'responsive' => true,
                'options' => [
                    '' => esc_html__('Default', 'tjcore'),
                    'auto' => esc_html__('Auto', 'tjcore'),
                    'cover' => esc_html__('Cover', 'tjcore'),
                    'contain' => esc_html__('Contain', 'tjcore'),
                    'initial' => esc_html__('Custom', 'tjcore'),
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'background-size: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_width',
            [
                'label' => esc_html__('Width', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'responsive' => true,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'required' => true,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'background-size: {{SIZE}}{{UNIT}} auto',

                ],
                'condition' => [
                    'tj_' . $control_id . '_slide_size' => ['initial'],
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_position',
            [
                'label' => esc_html__('Background Position', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'responsive' => true,
                'options' => [
                    '' => esc_html__('Default', 'tjcore'),
                    'center center' => esc_html__('Center Center', 'tjcore'),
                    'center left' => esc_html__('Center Left', 'tjcore'),
                    'center right' => esc_html__('Center Right', 'tjcore'),
                    'top center' => esc_html__('Top Center', 'tjcore'),
                    'top left' => esc_html__('Top Left', 'tjcore'),
                    'top right' => esc_html__('Top Right', 'tjcore'),
                    'bottom center' => esc_html__('Bottom Center', 'tjcore'),
                    'bottom left' => esc_html__('Bottom Left', 'tjcore'),
                    'bottom right' => esc_html__('Bottom Right', 'tjcore'),
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'background-position: {{VALUE}};',
                ]
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_repeater',
            [
                'label' => esc_html__('Background Repeat', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'responsive' => true,
                'options' => [
                    '' => esc_html__('Default', 'tjcore'),
                    'no-repeat' => esc_html__('No-repeat', 'tjcore'),
                    'repeat' => esc_html__('Repeat', 'tjcore'),
                    'repeat-x' => esc_html__('Repeat-x', 'tjcore'),
                    'repeat-y' => esc_html__('Repeat-y', 'tjcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'background-repeat: {{VALUE}};',
                ]
            ]
        );
        $background_overlay_selector = '{{WRAPPER}} ' .  $control_selector . '::before, {{WRAPPER}} ' .  $control_selector . '::after ';
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tj_' . $control_id . '_background_overlay',
                'selector' => $background_overlay_selector,
                'fields_options' => [
                    'background' => [
                        'selectors' => [
                            $background_overlay_selector => 'background-color: {{VALUE}};',
                        ],
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'tj_' . $control_id . '_overlay_opacity',
            [
                'label' => esc_html__('Opacity', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => .5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' .  $control_selector . '::before, 
                    {{WRAPPER}} ' .  $control_selector . '::after ' => 'opacity: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'tj_' . $control_id . '_slide_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'separator' => 'before',
            ]
        );
        $this->end_controls_section();
    }

    /*  
    *  Image Style Controls 
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */

    protected function tj_img_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {
        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition,
            ];
        }

        $this->start_controls_section('tj_' . $control_id . '_image_styling', $section_args);

        $this->add_control(
            'tj_' . $control_id . '_image_width',
            [
                'label' => esc_html__('Width', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_image_height',
            [
                'label' => esc_html__('Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tj_' . $control_id . '_image_fit',
            [
                'label' => esc_html__('Object Fit', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__('Default', 'tjcore'),
                    'fill' => esc_html__('Fill', 'tjcore'),
                    'cover' => esc_html__('Cover', 'tjcore'),
                    'contain' => esc_html__('Contain', 'tjcore'),
                    'scale-down' => esc_html__('Scale Down', 'tjcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'object-fit: {{VALUE}};',
                ],
                'condition' => [
                    'tj_' . $control_id . '_image_height[size]!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'tj_' . $control_id . '_image_position',
            [
                'label' => esc_html__('Object Position', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'center center' => esc_html__('Center Center', 'tjcore'),
                    'center left' => esc_html__('Center Left', 'tjcore'),
                    'center right' => esc_html__('Center Right', 'tjcore'),
                    'top center' => esc_html__('Top Center', 'tjcore'),
                    'top left' => esc_html__('Top Left', 'tjcore'),
                    'top right' => esc_html__('Top Right', 'tjcore'),
                    'bottom center' => esc_html__('Bottom Center', 'tjcore'),
                    'bottom left' => esc_html__('Bottom Left', 'tjcore'),
                    'bottom right' => esc_html__('Bottom Right', 'tjcore'),
                ],
                'default' => 'center center',
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'object-position: {{VALUE}};',
                ],
                'condition' => [
                    'tj_' . $control_id . '_image_height[size]!' => '',
                    'tj_' . $control_id . '_image_fit' => ['cover', 'contain', 'scale-down'],
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_image_separator',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $this->start_controls_tabs('tj_' . $control_id . '_image_effect');

        // Normal Tab
        $this->start_controls_tab('tj_' . $control_id . '_image_normal', [
            'label' => esc_html__('Normal', 'tjcore'),
        ]);

        $this->add_control(
            'tj_' . $control_id . '_image_opacity',
            [
                'label' => esc_html__('Opacity', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Css_Filter::get_type(),
            [
                'name' => 'tj_' . $control_id . '_image_filter',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' img',
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab('tj_' . $control_id . '_image_hover', [
            'label' => esc_html__('Hover', 'tjcore'),
        ]);

        $this->add_control(
            'tj_' . $control_id . '_image_hover_opacity',
            [
                'label' => esc_html__('Opacity', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.1,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ':hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Css_Filter::get_type(),
            [
                'name' => 'tj_' . $control_id . '_image_hover_filter',
                'selector' => '{{WRAPPER}} ' . $control_selector . ':hover img',
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_image_transition',
            [
                'label' => esc_html__('Transition Duration', 'tjcore') . ' (s)',
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Border + Radius
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tj_' . $control_id . '_image_border',
                'selector' => '{{WRAPPER}} ' . $control_selector . ' img',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_image_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /*      
    *  Input Style Controls
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */

    protected function tj_input_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {
        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition
            ];
        }

        $this->start_controls_section(
            'tj_' . $control_id . '_input',
            $section_args
        );

        // Combined input types
        $input_targets = '{{WRAPPER}} ' . $control_selector . ' :is(input[type="text"], input[type="email"], input[type="url"], input[type="tel"], input[type="search"], textarea)';
        $input_focus_targets = $input_targets . ':focus';
        $placeholder_targets = '{{WRAPPER}} ' . $control_selector . ' :is(input[type="text"], input[type="email"], input[type="url"], input[type="tel"], input[type="search"], textarea)::placeholder';

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'tj_' . $control_id . '_input_typography',
                'selector' => $input_targets,
            ]
        );

        $this->start_controls_tabs('tj_' . $control_id . '_input_tabs');

        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_input_normal', ['label' => esc_html__('Normal', 'tjcore')]);

        $this->add_control(
            'tj_' . $control_id . '_input_normal_text_color',
            [
                'label' => esc_html__('Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $input_targets => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_input_normal_bg_color',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $input_targets => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_input_normal_placeholder_color',
            [
                'label' => esc_html__('Placeholder Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $placeholder_targets => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_input_normal_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $input_targets => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_input_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => $input_targets,
            ]
        );

        $this->end_controls_tab();

        // Focus State Tab
        $this->start_controls_tab('tj_' . $control_id . '_input_hover', ['label' => esc_html__('Focus', 'tjcore')]);

        $this->add_control(
            'tj_' . $control_id . '_input_hover_bg_color',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $input_focus_targets => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_input_hover_border_color',
            [
                'label' => esc_html__('Border Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    $input_focus_targets => 'border-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tj_' . $control_id . '_input_hover_box_shadow',
                'label' => esc_html__('Box Shadow', 'tjcore'),
                'selector' => $input_focus_targets,
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'tj_' . $control_id . '_input_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    $input_targets => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tj_' . $control_id . '_input_padding',
            [
                'label' => esc_html__('Padding', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    $input_targets => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tj_' . $control_id . '_input_margin',
            [
                'label' => esc_html__('Margin', 'tjcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    $input_targets => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }


    /*      
    *  Pagination Style Controls
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */

    protected function tj_swiper_dot_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {

        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition,
            ];
        }

        $this->start_controls_section('tj_' . $control_id . '_dots_styling', $section_args);

        $this->add_control(
            'tj_' . $control_id . '_dots_width',
            [
                'label' => esc_html__('Width', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_dots_height',
            [
                'label' => esc_html__('Height', 'tjcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tj_' . $control_id . '_bullet_tabs');
        // Normal State Tab
        $this->start_controls_tab('tj_' . $control_id . '_bullet_normal', ['label' => esc_html__('Normal', 'tjcore')]);

        $this->add_control(
            'tj_' . $control_id . '_bullet_normal_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();
        // Hover State Tab
        $this->start_controls_tab('tj_' . $control_id . '_bullet_hover', ['label' => esc_html__('Active', 'tjcore')]);

        $this->add_control(
            'tj_' . $control_id . '_bullet_active_bg',
            [
                'label' => esc_html__('Background Color', 'tjcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .swiper-pagination-bullet.swiper-pagination-bullet-active'  => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    /*      
    *  Navigation Style Controls
    1. $control_id -> Tab ID
    2. $control_name -> Tab Title
    3. $control_selector -> Selector Class or ID
    */

    protected function tj_swiper_nav_style_controls($control_id = null, $control_name = null, $control_selector = null, $condition = null)
    {


        $section_args = [
            'label' => esc_html__($control_name, 'tjcore'),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ];

        if ($condition) {
            $section_args['condition'] = [
                'tj_design_style!' => $condition,
            ];
        }

        $this->start_controls_section('tj_' . $control_id . '_nav_style_section', $section_args);

        $this->start_controls_tabs('tj_' . $control_id . '_nav_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'tj_' . $control_id . '_nav_normal_tab',
            [
                'label' => esc_html__('Normal', 'tjcore'),
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_bg_color',
            [
                'label'     => esc_html__('Background Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_border_color',
            [
                'label'     => esc_html__('Border Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab(
            'tj_' . $control_id . '_nav_hover_tab',
            [
                'label' => esc_html__('Hover', 'tjcore'),
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_hover_color',
            [
                'label'     => esc_html__('Icon Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_bg_hover_color',
            [
                'label'     => esc_html__('Background Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next:hover' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tj_' . $control_id . '_icon_border_hover_color',
            [
                'label'     => esc_html__('Border Color', 'tjcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} ' . $control_selector . ' .slider-next:hover' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} ' . $control_selector . ' .slider-prev:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
}
