<?php

/** 
 * This template for projects archive
 *
 * @package TJCore/CustomPost
 * @author  Theme Junction 
 * @since   1.0.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}

get_header();

if (!function_exists('elementor_theme_do_location') || !elementor_theme_do_location('archive')) {

  $showProjects = get_theme_mod('show_projects_item', -1);

  $args = array(
    'post_type' => 'projects',
    'post_status' => 'publish',
    'posts_per_page' => $showProjects,
    'order' => 'DESC',
  );

  $query = new \WP_Query($args);

  $projects_title = get_theme_mod('projects_title', true);
  $project_category = get_theme_mod('projects_category', true);
  $projects_icon_btn = get_theme_mod('projects_icon_btn', true);
  $project_icon = get_theme_mod('project_icon');

?>

  <!-- Start: Project Area -->
  <section class="tj-project-page section-gap">
    <div class="container">
      <?php if ($query->have_posts()) : ?>
        <div class="row row-gap-4">

          <?php while ($query->have_posts()) : $query->the_post();

            $categories = get_the_terms(get_the_ID(), 'projects-cat');
          ?>
            <div class="col-xl-4 col-md-6">
              <div class="project-item wow fadeInUp" data-wow-delay="0.2s">
                <?php if (has_post_thumbnail()): ?>
                  <div class="project-image">
                    <a href="<?php the_permalink(); ?>">
                      <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
                    </a>
                  </div>
                <?php endif; ?>
                <div class="project-content">
                  <?php if (!empty($categories) || !empty($project_category)): ?>
                    <span class="categories">
                      <?php
                      $category_names = array();
                      foreach ($categories as $cat) {
                        $category_names[] = '<a href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
                      }
                      echo implode(' ', $category_names);
                      ?>
                    </span>
                  <?php endif; ?>
                  <?php if (!empty($projects_title) || !empty($projects_icon_btn)): ?>
                    <div class="project-text">
                      <?php if (!empty($projects_title)): ?>
                        <h4 class="title"><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></h4>
                      <?php endif; ?>
                      <?php if (!empty($projects_icon_btn)): ?>
                        <a class="project-btn" href="<?php the_permalink(); ?>">
                          <?php echo tj_kses($project_icon); ?>
                        </a>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>

        </div>
      <?php else :
        printf("%s", esc_html__("No projects available!", 'tjcore'));
      endif; ?>
    </div>
  </section>
  <!-- end: Project Area -->

<?php
}
get_footer();
