<?php

/**
 * Header Template
 *
 * The template for displaying the <head> section and the header area of the site.
 *
 * @package TJCore/ThemeBuilder
 * @author ThemeJunction 
 * @since 1.0.0
 */

if (! defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>" />
	<?php if (is_singular() && pings_open(get_queried_object())) : ?>
		<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
	<?php endif; ?>
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'tjcore'); ?></a>

	<?php
	/**
	 * Hook: tj_header_builder_content.
	 *
	 * Output custom header builder content (Elementor or theme).
	 */
	do_action('tj_header_builder_content'); ?>

	<?php
	/**
	 * Hook: tj_before_main_content.
	 *
	 * Before the main content wrapper starts.
	 */
	do_action('tj_before_main_content'); ?>

	<?php
	/**
	 * Hook: tj_page_header.
	 *
	 * Page header content, like breadcrumbs or titles.
	 */
	do_action('tj_page_header'); ?>

	<!-- Start Main Content -->
	<main id="content" class="site-main tj-content">