<?php

/**
 * Bexon Child Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

if (!defined('WP_DEBUG')) {
   die('Direct access forbidden.');
}

add_action('wp_enqueue_scripts', 'bexon_child_enqueue_styles', 99);

function bexon_child_enqueue_styles()
{
   // enqueue the parent stylesheet
   wp_enqueue_style('parent-style', get_stylesheet_directory_uri() . '/style.css');

   // enqueue the parent RTL stylesheet
   if (is_rtl()) {
      wp_enqueue_style('parent-rtl', get_template_directory_uri() . '/rtl.css');
   }

   // enqueue the child stylesheet
   wp_enqueue_style('child-style', get_stylesheet_uri());
}
