<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

get_header();

$bexonErrorImage = get_theme_mod('error_image', BEXON_ASSETS_IMAGES_URL . '/404/error.webp');
$bexonErrorTitle = get_theme_mod('error_title', esc_html__('Opps! That Links Is Broken', 'bexon'));
$bexonErrorDesc = get_theme_mod('error_desc', esc_html__('Page does not exist or some other error occurred. Go to our Home Page', 'bexon'));
$bexonErrorBtnText = get_theme_mod('error_btn_text', esc_html__('Go back to home', 'bexon'));
?>

<section class="tj-error-section">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="tj-error-wrap text-center">
					<div class="tj-error-content">
						<?php if (!empty($bexonErrorImage)): ?>
							<div class="error-img">
								<img src="<?php echo esc_url($bexonErrorImage); ?>" alt="<?php echo esc_attr(get_post_meta(attachment_url_to_postid($bexonErrorImage), '_wp_attachment_image_alt', true)); ?>">
							</div>
						<?php endif; ?>

						<?php if (!empty($bexonErrorTitle)): ?>
							<h2 class="error-title title-anim"><?php echo esc_html($bexonErrorTitle); ?></h2>
						<?php endif; ?>

						<?php if (!empty($bexonErrorDesc)): ?>
							<div class="error-desc"><?php echo esc_html($bexonErrorDesc); ?></div>
						<?php endif; ?>

						<?php if (!empty($bexonErrorBtnText)): ?>
							<a class="tj-primary-btn error-btn" href="<?php echo esc_url(home_url('/')); ?>">
								<span class="btn-text"><span><?php echo esc_html($bexonErrorBtnText); ?></span></span>
								<span class="btn-icon"><i class="tji-arrow-right-long"></i></span>
							</a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php
get_footer();
