/***************************************************
==================== JS INDEX ======================
****************************************************
Preloader js
Data js
Sticky Nav Js
Mobile Menu Js
Search Bar Js
Rating Js
Accordion Js
Backtotop Js
VenoBox Js
Progressbar js

****************************************************/

(function ($) {
  "use strict";

  // Preloader js
  $(window).on("load", function () {
    const preLoader = $(".preloader");
    const tjPreloader = $(".tj-preloader");

    const runControllers = () => {
      wowController();
      gsapController();
      counterController();
    };

    if (tjPreloader.length) {
      // Handle tj-preloader (style-1)
      setTimeout(function () {
        tjPreloader.removeClass("is-loading").addClass("is-loaded");
        setTimeout(function () {
          tjPreloader.fadeOut(400);
          runControllers();
        }, 700);
      }, 2000);
    } else if (preLoader.length) {
      // Handle image/logo-based preloader (style-2)
      setTimeout(function () {
        setTimeout(function () {
          preLoader.fadeOut(400);
          runControllers();
        }, 700);
      }, 2000);
    } else {
      runControllers();
    }
  });

  // Data js
  $("[data-bg-image]").each(function () {
    var $this = $(this),
      $image = $this.data("bg-image");
    $this.css("background-image", "url(" + $image + ")");
  });

  $("[data-max-width]").each(function () {
    var $this = $(this),
      width = $this.data("max-width");
    $this.css("max-width", width);
  });

  // Sticky menu function
  let lastScrollTop = 0;
  const scrollThreshold = 400;
  function handleStickyMenu($menu, toggleClass) {
    const scrollTop = $(window).scrollTop();
    if (scrollTop > scrollThreshold) {
      if (scrollTop > lastScrollTop) {
        $menu.removeClass(toggleClass);
      } else {
        $menu.addClass(toggleClass);
      }
    } else {
      $menu.removeClass(toggleClass);
    }
    lastScrollTop = scrollTop;
  }

  // Scroll handler
  $(window).on("scroll", function () {
    const stickyUp = $(".sticky-up");
    const stickyDown = $(".sticky-down");
    const scrollTop = $(window).scrollTop();
    if (stickyDown.length) {
      stickyDown.toggleClass("sticky", scrollTop >= scrollThreshold);
    } else if (stickyUp.length) {
      handleStickyMenu(stickyUp, "sticky");
    }
  });

  // Mobile Menu Js
  $(".mobile_menu_bar").on("click", function () {
    $(this).toggleClass("on");
  });

  // Mobile Menu Js
  $("#mobile-menu").meanmenu({
    meanMenuContainer: ".mobile_menu",
    meanScreenWidth: "1024",
    meanExpand: ['<i class="tji-arrow-down"></i>'],
  });

  // Hamburger Menu Js
  $(".mobile_menu_bar").on("click", function () {
    $(".hamburger-area").addClass("opened");
    $(".body-overlay").addClass("opened");
    $("body").toggleClass("overflow-hidden");
  });

  // Offcanvas js
  $(".menu_offcanvas").on("click", function () {
    $(".tj-offcanvas-area").toggleClass("opened");
    $(".body-overlay").addClass("opened");
    $("body").toggleClass("overflow-hidden");
  });
  $(".hamburger_close_btn").on("click", function () {
    $(".tj-offcanvas-area").removeClass("opened");
    $(".hamburger-area").removeClass("opened");
    $(".body-overlay").removeClass("opened");
    $("body").toggleClass("overflow-hidden");
  });
  $(".body-overlay").on("click", function () {
    $(".tj-offcanvas-area").removeClass("opened");
    $(".hamburger-area").removeClass("opened");
    $(".body-overlay").removeClass("opened");
    $("body").toggleClass("overflow-hidden");
  });

  // Search Bar Js
  $(".header-search .search").on("click", function () {
    $(this).addClass("search-hide");
    $(".search_close_btn").addClass("close-show");
    $(".search_popup").addClass("search-opened");
    $(".search-popup-overlay").addClass("search-popup-overlay-open");
  });
  $(".search_close_btn, .search-popup-overlay").on("click", function () {
    $(".header-search .search").removeClass("search-hide");
    $(".search_popup").removeClass("search-opened");
    $(".search-popup-overlay").removeClass("search-popup-overlay-open");
    $(".search_close_btn").removeClass("close-show");
  });

  // Rating Js
  if ($(".fill-ratings span").length > 0) {
    var star_rating_width = $(".fill-ratings span").width();
    $(".star-ratings").width(star_rating_width);
  }

  // Nice Select Js
  if ($("select").length > 0) {
    $(".tj-el-form select, .tj-shop-from select").niceSelect();
  }

  /* Blog gallery slider
  -------------------------------*/
  if ($(".blog-gallery-slider").length > 0) {
    let blog = new Swiper(".blog-gallery-slider", {
      slidesPerView: 1,
      spaceBetween: 20,
      loop: true,
      speed: 1200,
      autoplay: {
        delay: 5000,
      },
      navigation: {
        nextEl: ".slider-next",
        prevEl: ".slider-prev",
      },
    });
  }

  // Accordion Js
  if ($(".accordion-item").length > 0) {
    $(".accordion-item .faq-title").on("click", function () {
      if ($(this).parent().hasClass("active")) {
        $(this).parent().removeClass("active");
      } else {
        $(this).parent().siblings().removeClass("active");
        $(this).parent().addClass("active");
      }
    });
  }

  // Backtotop Js
  function tjBaackTopController() {
    const scrollElementWrap = $("#tj-back-to-top");
    if (scrollElementWrap?.length) {
      const scrollPercentage = () => {
        const scrollTopPos = document.documentElement.scrollTop;
        const calcHeight = document.documentElement.scrollHeight - document.documentElement.clientHeight;
        const scrollValue = Math.round((scrollTopPos / calcHeight) * 100);

        scrollElementWrap.css("background", `conic-gradient( var(--tj-color-theme-primary) ${scrollValue}%, var(--tj-color-common-white) ${scrollValue}%)`);

        // ScrollProgress
        if (scrollTopPos > 1000) {
          scrollElementWrap.addClass("active");
        } else {
          scrollElementWrap.removeClass("active");
        }

        if (scrollValue < 96) {
          $("#tj-back-to-top-percentage").text(`${scrollValue}%`);
        } else {
          $("#tj-back-to-top-percentage").html('<i class="tji-arrow-up-long"></i>');
        }
      };
      window.onscroll = scrollPercentage;
      window.onload = scrollPercentage;

      // Back to Top
      function scrollToTop() {
        document.documentElement.scrollTo({
          top: 0,
          behavior: "smooth",
        });
      }

      $("#tj-back-to-top").on("click", scrollToTop);
    }
  }
  tjBaackTopController();

  // wow js

  function wowController() {
    if ($(".wow").length > 0) {
      new WOW().init();
    }
  }

  // VenoBox Js
  if ($(".tj-gallery-item").length > 0) {
    $(".tj-gallery-item").magnificPopup({
      delegate: "a",
      type: "image",
      closeOnContentClick: false,
      closeBtnInside: false,
      mainClass: "mfp-with-zoom",
      image: {
        verticalFit: true,
      },
      gallery: {
        enabled: true,
      },
      zoom: {
        enabled: true,
        duration: 300,
        opener: function (element) {
          return element.find("img");
        },
      },
    });
  }

  if ($(".video-popup").length > 0) {
    $(".video-popup").magnificPopup({
      type: "iframe",
      mainClass: "mfp-fade",
      removalDelay: 160,
      preloader: false,
      fixedContentPos: true,
    });
  }

  // counter
  function counterController() {
    if (jQuery(".counter").length > 0) {
      $(".counter").counterUp({
        delay: 10,
        time: 1000,
      });
    }
  }

  // team
  if ($(".team-wrapper").length) {
    $(".team-item").on("mouseover", function () {
      $(this).siblings(".team-item").removeClass("active");
      $(this).addClass("active");
      const newSrc = $(this).data("src");
      const $image = $("#team-img img");

      $image
        .fadeOut(300)
        .css("transform", "scale(1.1)")
        .promise()
        .done(function () {
          $image.attr("src", newSrc).fadeIn(300).css("transform", "scale(1)");
        });
    });
  }

  // image slider
  const tjSliderImages = document.querySelectorAll(".tj-image-slider img");

  if (tjSliderImages?.length) {
    let index = 0;
    function showNextImage() {
      tjSliderImages.forEach((img) => img.classList.remove("active"));
      tjSliderImages[index].classList.add("active");
      index = (index + 1) % tjSliderImages.length;
    }

    // Initial display
    showNextImage();
    setInterval(showNextImage, 500);
  }

  // Portfolio Filter Js
  function initPortfolioFilter() {
    const $gridContainer = $(".grid");
    if (!$gridContainer.length) {
      return;
    }
    const $filterButtons = $(".filter-button-group");
    const $portfolioMenuButtons = $(".filter-button-group button");

    $gridContainer.imagesLoaded(function () {
      const $grid = $gridContainer.isotope();

      $filterButtons.on("click", "button", function () {
        const filterValue = $(this).attr("data-filter");
        $grid.isotope({ filter: filterValue });
      });

      $portfolioMenuButtons.on("click", function (event) {
        event.preventDefault();
        $portfolioMenuButtons.removeClass("active");
        $(this).addClass("active");
      });
    });
  }
  initPortfolioFilter();

  /* ------------- Gsap registration Js -------------*/
  gsap.registerPlugin(ScrollTrigger, ScrollToPlugin);
  gsap.config({
    nullTargetWarn: false,
  });

  function gsapController() {
    let mediaMatch = gsap.matchMedia();

    function rtlValue(value) {
      const isRTL = document.documentElement.dir === "rtl";
      return isRTL ? -value : value;
    }

    /* Text Effect Animation */
    if ($(".text-anim").length) {
      let staggerAmount = 0.02,
        translateXValue = rtlValue(20),
        delayValue = 0.1,
        easeType = "power2.out",
        animatedTextElements = document.querySelectorAll(".text-anim");

      animatedTextElements.forEach((element) => {
        let animationSplitText = new SplitText(element, { type: "chars, words" });
        gsap.from(animationSplitText.chars, {
          duration: 1,
          delay: delayValue,
          x: translateXValue,
          autoAlpha: 0,
          stagger: staggerAmount,
          ease: easeType,
          scrollTrigger: { trigger: element, start: "top 85%" },
        });
      });
    }

    /* Title Animation */
    if ($(".title-anim").length) {
      let staggerAmount = 0.01,
        delayValue = 0.1,
        easeType = "power1.inout",
        animatedTitleElements = document.querySelectorAll(".title-anim");

      animatedTitleElements.forEach((element) => {
        let animatedTitleElements = new SplitText(element, {
          types: "lines, words",
        });
        gsap.from(animatedTitleElements.chars, {
          y: "100%",
          duration: 0.5,
          delay: delayValue,
          autoAlpha: 0,
          stagger: staggerAmount,
          ease: easeType,
          scrollTrigger: { trigger: element, start: "top 85%" },
        });
      });
    }

    // right swipe
    document.querySelectorAll(".rightSwipeWrap").forEach((wrap, i) => {
      gsap.set(wrap.querySelectorAll(".right-swipe"), {
        transformPerspective: 1200,
        x: "10rem",
        rotateY: -20,
        opacity: 0,
        transformOrigin: "right center",
      });
      gsap.to(wrap.querySelectorAll(".right-swipe"), {
        transformPerspective: 1200,
        x: 0,
        rotateY: 0,
        opacity: 1,
        delay: 0.3,
        ease: "power3.out",
        scrollTrigger: {
          trigger: wrap,
          start: "top 80%",
          id: "rightSwipeWrap-" + i,
          toggleActions: "play none none none",
        },
      });
    });

    // left swipe
    document.querySelectorAll(".leftSwipeWrap").forEach((wrap, i) => {
      gsap.set(wrap.querySelectorAll(".left-swipe"), {
        transformPerspective: 1200,
        x: "-10rem",
        rotateY: 20,
        opacity: 0,
        transformOrigin: "left center",
      });
      gsap.to(wrap.querySelectorAll(".left-swipe"), {
        transformPerspective: 1200,
        x: 0,
        rotateY: 0,
        opacity: 1,
        delay: 0.4,
        ease: "power3.out",
        scrollTrigger: {
          trigger: wrap,
          start: "top 80%",
          id: "leftSwipeWrap-" + i,
          toggleActions: "play none none none",
        },
      });
    });

    // Text Invert
    if ($(".tj-text-invert").length) {
      const split = new SplitText(".tj-text-invert", { type: "lines" });
      split.lines.forEach((target) => {
        gsap.to(target, {
          backgroundPositionX: 0,
          ease: "none",
          scrollTrigger: {
            trigger: target,
            scrub: 1,
            start: "top 75%",
            end: "bottom center",
          },
        });
      });
    }

    // Text Highlight
    if ($(".title-highlight").length) {
      const highlightText = new SplitText(".title-highlight", {
        type: "lines",
        linesClass: "line",
      });

      const tl = gsap.timeline({
        scrollTrigger: {
          trigger: ".title-highlight",
          scrub: 1,
          start: "top 80%",
          end: "bottom center",
        },
      });
      tl.to(".line", {
        "--highlight-offset": "100%",
        stagger: 0.4,
      });
    }

    // Images parallax
    if ($(".img-parallax").length > 0) {
      mediaMatch.add("(min-width: 1025px)", () => {
        gsap.utils.toArray(".img-parallax").forEach((container) => {
          const img = container.querySelector("img");
          const tl = gsap.timeline({
            scrollTrigger: {
              trigger: container,
              scrub: 1,
              pin: false,
            },
          });

          tl.fromTo(
            img,
            {
              yPercent: 0,
              ease: "none",
            },
            {
              yPercent: -30,
              ease: "none",
            }
          );
        });
      });
    }

    // h9 service sticky
    function initStickyAndProgress() {
      if ($(".tj-sticky-panel-2").length > 0) {
        let tl = gsap.timeline();
        let panels = document.querySelectorAll(".tj-sticky-panel-2");
        panels.forEach((panel, i) => {
          tl.to(panel, {
            scrollTrigger: {
              trigger: panel,
              pin: panel,
              scrub: 1,
              start: "top top",
              end: "bottom+=120 bottom",
              endTrigger: ".tj-sticky-panel-container-2",
              pinSpacing: false,
              markers: false,
            },
          });
        });
      }

      // Scroll Progress animation
      if ($(".tj-progress-item").length > 0) {
        const tjProgressWrapper = document.querySelector(".tj-progress-wrapper");

        if (tjProgressWrapper?.children?.length) {
          let panels = gsap.utils.toArray(".tj-progress-item");
          let totalPanels = panels.length;
          let scrollProgressItems = gsap.utils.toArray(".tj-scroll-progress-item");

          gsap.to(panels, {
            ease: "none",
            scrollTrigger: {
              trigger: tjProgressWrapper,
              start: "top top",
              end: "bottom bottom",
              scrub: 1,
              pin: false,
              onUpdate: (self) => {
                let progress = self.progress;
                let activeIndex = Math.round(progress * (totalPanels - 1));

                panels.forEach((panel, index) => {
                  panel.classList.toggle("active", index === activeIndex);
                });
                scrollProgressItems.forEach((item, index) => {
                  item.classList.toggle("active", index === activeIndex);
                });
              },
            },
          });
        }
      }
    }
    initStickyAndProgress();

    // h10 process sticky
    function initStickyPanel3Animation() {
      const container = document.querySelector(".tj-sticky-panel-3-container");
      const panels = document.querySelectorAll(".tj-sticky-panel-3");
      if (!container || panels.length === 0) return;
      mediaMatch.add("(min-width: 1025px)", () => {
        const startOffset = parseInt(getComputedStyle(container).paddingTop) || 0;
        const lastIdx = panels.length - 1;
        const lastPanel = panels[lastIdx];
        const paddingBottom = parseInt(getComputedStyle(container).paddingBottom) || 0;
        panels.forEach((panel, i) => {
          gsap.to(panel, {
            scrollTrigger: {
              trigger: panel,
              start: `top-=${startOffset} top`,
              endTrigger: container,
              end: () => `bottom top+=${lastPanel.offsetHeight + startOffset + paddingBottom}`,
              pin: true,
              pinSpacing: false,
              scrub: true,
              markers: false,
              invalidateOnRefresh: true,
            },
            ease: "circ",
            opacity: i === 0 || i === lastIdx ? 1 : 0.1,
          });
        });
      });
    }
    initStickyPanel3Animation();

    // Sidebar sticky
    function sidebarStickyController() {
      const containers = document.querySelectorAll(".sidebar-sticky-container");
      if (containers.length) {
        containers.forEach((container) => {
          const panels = container.querySelectorAll(".sidebar-sticky");
          if (panels.length) {
            mediaMatch.add("(min-width: 1025px)", () => {
              const startOffset = 30;
              //parseInt(getComputedStyle(container).paddingTop) || 0;
              const lastIdx = panels.length - 1;
              const lastPanel = panels[lastIdx];
              const paddingBottom = parseInt(getComputedStyle(container).paddingBottom) || 0;
              panels.forEach((panel, i) => {
                gsap.to(panel, {
                  scrollTrigger: {
                    trigger: panel,
                    start: `top-=${startOffset} top`,
                    endTrigger: container,
                    end: () => `bottom top+=${lastPanel.offsetHeight + startOffset + paddingBottom}`,
                    pin: true,
                    pinSpacing: false,
                    scrub: true,
                    markers: false,
                    invalidateOnRefresh: true,
                  },
                  ease: "circ",
                });
              });
            });
          }
        });
      }
    }
    sidebarStickyController();

    // h10 video zoom
    if ($(".zoom-on-scroll").length > 0) {
      mediaMatch.add("(min-width: 0)", () => {
        let zoomElements = document.querySelectorAll(".zoom-on-scroll");
        // Set initial scale
        gsap.set(zoomElements, {
          scale: 0.74,
          transformOrigin: "top center",
        });
        // Animate to scale 1 on scroll
        gsap.to(zoomElements, {
          scale: 1,
          ease: "none",
          scrollTrigger: {
            trigger: ".zoom-on-scroll-wrapper",
            start: "top top",
            end: "top+=30% top",
            scrub: true,
          },
        });
      });
    }

    /* new gsap animation start */
    // Arrange on Scroll Animation
    function initArrangeAnim() {
      const panelsContainers = document.querySelectorAll(".tj-arrange-container");
      if (panelsContainers?.length) {
        mediaMatch.add("(min-width: 1025px)", () => {
          panelsContainers.forEach((panelsContainer, idx) => {
            const panels = panelsContainer.querySelectorAll(".tj-arrange-item");

            panels.forEach((panel, i) => {
              gsap.from(panel, {
                xPercent: i % 2 === 0 ? rtlValue(-20) : rtlValue(20),
                ease: "none",
                scrollTrigger: {
                  trigger: panel,
                  start: `top bottom`,
                  end: `bottom bottom`,
                  pin: false,
                  pinSpacing: false,
                  scrub: true,
                  markers: false,
                  invalidateOnRefresh: true,
                },
              });
            });
          });
        });
      }
    }
    initArrangeAnim();

    // Arrange on Scroll Animation 2
    function initArrangeAnim2() {
      const panelsContainers = document.querySelectorAll(".tj-arrange-container-2");
      if (panelsContainers?.length) {
        mediaMatch.add("(min-width: 1025px)", () => {
          panelsContainers.forEach((panelsContainer, idx) => {
            const panels = panelsContainer.querySelectorAll(".tj-arrange-item-2");
            panels.forEach((panel, i) => {
              gsap.from(panel, {
                xPercent: i % 2 === 0 ? rtlValue(-30) : rtlValue(30),
                ease: "none",
                scrollTrigger: {
                  trigger: panel,
                  start: `top bottom`,
                  end: `${i === 0 || i === 2 ? "bottom+=200" : "bottom+=300"} bottom`,
                  pin: false,
                  pinSpacing: false,
                  scrub: true,
                  markers: false,
                  invalidateOnRefresh: true,
                },
              });
            });
          });
        });
      }
    }
    initArrangeAnim2();
  }
})(jQuery);
