<?php

/**
 * Bexon Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Bexon_Theme
 * @since Bexon 1.0.0
 * @author Theme Junction 
 */

/**
 *---------------------------------------------------------------------------------------
 * Define constants
 *---------------------------------------------------------------------------------------
 */
define('BEXON_THEME_NAME', 'Bexon');
define('BEXON_THEME_SLUG', 'bexon');

define('BEXON_THEME_VERSION', '1.0.8');

define('BEXON_THEME_DIR', get_template_directory());
define('BEXON_THEME_URL', get_template_directory_uri());
define('BEXON_STYLESHEET_URL', get_stylesheet_uri());

define('BEXON_INC_DIR', BEXON_THEME_DIR . '/inc');
define('BEXON_INC_URL', BEXON_THEME_URL . '/inc');

define('BEXON_COMMON_DIR', BEXON_THEME_DIR . '/inc/common');
define('BEXON_COMMON_URL', BEXON_THEME_URL . '/inc/common');

define('BEXON_CUSTOMIZER_DIR', BEXON_INC_DIR . '/customizer/');

define('BEXON_TEMPLATE_PARTS', BEXON_THEME_DIR . '/template-parts/');

define('BEXON_ASSETS_DIR', BEXON_THEME_DIR . '/assets');
define('BEXON_ASSETS_URL', BEXON_THEME_URL . '/assets');

define('BEXON_ASSETS_CSS_DIR', BEXON_THEME_DIR . '/assets/css/');
define('BEXON_ASSETS_CSS_URL', BEXON_THEME_URL . '/assets/css/');

define('BEXON_ASSETS_JS_DIR', BEXON_THEME_DIR . '/assets/js/');
define('BEXON_ASSETS_JS_URL', BEXON_THEME_URL . '/assets/js/');

define('BEXON_ASSETS_IMAGES_DIR', BEXON_THEME_DIR . '/assets/images');
define('BEXON_ASSETS_IMAGES_URL', BEXON_THEME_URL . '/assets/images');

/**
 * ---------------------------------------------------------------------------------------
 * Template Hooks
 * ---------------------------------------------------------------------------------------
 */
require_once BEXON_INC_DIR . '/template-hooks.php';

/**
 * ---------------------------------------------------------------------------------------
 * Template Helpers
 * ---------------------------------------------------------------------------------------
 */
require_once BEXON_INC_DIR . '/template-helpers.php';

/**
 * ---------------------------------------------------------------------------------------
 * TGM Include
 * ---------------------------------------------------------------------------------------
 */
require_once BEXON_INC_DIR . '/lib/class-tgm-plugin-activation.php';
require_once BEXON_INC_DIR . '/lib/tgm-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Theme Customizer
 * ---------------------------------------------------------------------------------------
 */
require_once BEXON_INC_DIR . '/lib/class-kirki-customizer.php';
require_once BEXON_CUSTOMIZER_DIR . 'customizer-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Include Files
 * ---------------------------------------------------------------------------------------
 */
require_once BEXON_INC_DIR . '/template-functions.php';

require_once BEXON_INC_DIR . '/lib/class-navwalker.php';

if (defined('JETPACK__VERSION')) {
  require_once BEXON_INC_DIR . '/jetpack.php';
}

/**
 * ---------------------------------------------------------------------------------------
 * WooCommerce Include
 * ---------------------------------------------------------------------------------------
 */
if (class_exists('WooCommerce')) {
  require BEXON_INC_DIR . '/lib/woocommerce.php';
}
