<?php

/**
 * Customizer Blog Settings
 *
 * style for theme blogs
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_01',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Blog Page Settings', 'bexon') . '</div>',
];
// breadcrumb title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_page_title',
  'label'    => esc_html__('Blog Page Title', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Blog', 'bexon'),
];
// blog breadcrumb image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_pheader_img',
  'label'       => esc_html__('Blog Page Header Image', 'bexon'),
  'section'     => 'blog_settings',
];
// Blog button
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'show_blog_btn',
  'label'    => esc_html__('BTN On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => true,
];
// button text
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_btn_text',
  'label'    => esc_html__('Button text', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Read More', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'show_blog_btn',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

// category meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_category',
  'label'    => esc_html__('Category Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => false,
];
// author meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_author',
  'label'    => esc_html__('Author Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => false,
];
// date meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_date',
  'label'    => esc_html__('Date Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => false,
];

// blog details
$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_02',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Blog Single Page', 'bexon') . '</div>',
];
// blog details title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_single_page_title',
  'label'    => esc_html__('Blog Single Page Title', 'bexon'),
  'section'  => 'blog_settings',
];
// blog details image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_single_pheader_img',
  'label'       => esc_html__('Blog Single Page Header Image', 'bexon'),
  'section'     => 'blog_settings',
];

// single author meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_single_author',
  'label'    => esc_html__('Author Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => true,
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'bexon_blog_single_author_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'bexon'),
  'default'    => esc_html__('Authored by', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'bexon_blog_single_author',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// single date meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_single_date',
  'label'    => esc_html__('Date Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => true,
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'bexon_blog_single_date_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'bexon'),
  'default'    => esc_html__('Date Released', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'bexon_blog_single_date',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// single comment meta
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_single_comments',
  'label'    => esc_html__('Comments Meta On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => true,
];
$fields[] = [
  'type'     => 'text',
  'settings' => 'bexon_blog_single_comments_label',
  'section'  => 'blog_settings',
  'label'    => esc_html__('Author Label', 'bexon'),
  'default'    => esc_html__('Comments', 'bexon'),
  'active_callback' => [
    [
      'setting'  => 'bexon_blog_single_comments',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// blog social share
$fields[] = [
  'type'     => 'toggle',
  'settings' => 'bexon_blog_socials',
  'label'    => esc_html__('Socials Share On/Off', 'bexon'),
  'section'  => 'blog_settings',
  'default'  => false,
];
